/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.ant.SortedProperties;
import com.codename1.maven.AbstractCN1Mojo;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.tools.ant.taskdefs.Expand;

@Mojo(name="generate-archetype", requiresProject=false)
public class GenerateArchetypeFromTemplateMojo
extends AbstractCN1Mojo {
    @Parameter(required=true, property="template")
    private String template;
    @Parameter(required=true, property="outputDir", defaultValue="${basedir}")
    private File outputDir;
    private File baseArchetypeDir;
    @Parameter(property="overwrite", defaultValue="false")
    private boolean overwrite;

    @Override
    protected void executeImpl() throws MojoExecutionException, MojoFailureException {
        File tplFile = this.loadTemplate(this.template);
        if (tplFile.isFile() && tplFile.getName().endsWith(".java")) {
            this.processJavaFile(tplFile);
        } else if (tplFile.isFile() && tplFile.getName().endsWith(".kt")) {
            this.processKotlinFile(tplFile);
        }
    }

    private int countRepeats(String str, int startPos, char ch) {
        int count = 0;
        int len = str.length();
        for (int i = startPos; i < len; ++i) {
            if (str.charAt(i) == ch) {
                ++count;
                continue;
            }
            return count;
        }
        return count;
    }

    private String extractSectionFrom(String haystack, String sectionName) throws TemplateParseException {
        int sectionPos = haystack.indexOf("[" + sectionName + "]");
        if (sectionPos >= 0) {
            int startingPos = haystack.indexOf("---", sectionPos);
            if (startingPos < 0) {
                throw new TemplateParseException("Found section heading " + sectionName + " without body in " + haystack);
            }
            if (!("[" + sectionName + "]").equals(haystack.substring(sectionPos, startingPos).trim())) {
                throw new TemplateParseException("Illegal formatting in " + sectionName + " section.  There are characters between the header and the body.");
            }
            int separatorLength = this.countRepeats(haystack, startingPos, '-');
            assert (separatorLength > 2);
            String separator = haystack.substring(startingPos, startingPos + separatorLength);
            int endPos = haystack.indexOf(separator, startingPos + separatorLength);
            if (endPos < 0) {
                throw new TemplateParseException("No closing separator found for section " + sectionName);
            }
            return haystack.substring(startingPos + separatorLength, endPos).trim();
        }
        return "";
    }

    private String extractDependencies(String str) throws TemplateParseException {
        return this.extractSectionFrom(str, "dependencies");
    }

    private String extractProperties(String str) throws TemplateParseException {
        return this.extractSectionFrom(str, "properties");
    }

    private String extractCSS(String str) throws TemplateParseException {
        return this.extractSectionFrom(str, "css");
    }

    private List<FileContent> extractFiles(String str) throws TemplateParseException {
        ArrayList<FileContent> out = new ArrayList<FileContent>();
        Scanner scanner = new Scanner(this.extractSectionFrom(str, "files"));
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line == null || line.trim().isEmpty()) continue;
            String content = this.extractSectionFrom(str, "file:" + line.trim());
            out.add(new FileContent(line, content));
        }
        return out;
    }

    private String replaceVariables(String content, Map<String, String> variables) {
        for (String key : variables.keySet()) {
            if (key.indexOf(".") >= 0) {
                throw new IllegalArgumentException("Variable keys should not contain a '.'.  This is to ensure that they don't conflict with maven properties.  Found key " + key);
            }
            content = content.replace("${" + key + "}", variables.get(key));
        }
        return content;
    }

    private String replaceVariables(String content) {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("package", this.properties.getProperty("codename1.packageName"));
        vars.put("mainName", this.properties.getProperty("codename1.mainName"));
        return this.replaceVariables(content, vars);
    }

    private void processString(String contents, File projectDir) throws MojoExecutionException {
        File archetypeResourcesDir = new File(projectDir, this.path("src", "main", "resources", "archetype-resources"));
        try {
            String css;
            String properties;
            String pomContents;
            File commonProjectDir = new File(archetypeResourcesDir, "common");
            File pomFile = new File(commonProjectDir, "pom.xml");
            File codenameoneSettingsProperties = new File(commonProjectDir, "codenameone_settings.properties");
            File themeCss = new File(commonProjectDir, "src" + File.separator + "main" + File.separator + "css");
            String origPomContents = pomContents = FileUtils.readFileToString((File)pomFile, (String)"UTF-8");
            String dependencies = this.extractDependencies(contents);
            if (!dependencies.isEmpty()) {
                this.getLog().info((CharSequence)("Injecting dependencies:\n" + dependencies + " \ninto " + pomFile));
                String marker = "<!-- INJECT DEPENDENCIES -->";
                pomContents = pomContents.replace(marker, dependencies + "\n" + marker);
            }
            if (!(properties = this.extractProperties(contents)).isEmpty()) {
                SortedProperties props = new SortedProperties();
                props.load(new StringReader(properties));
                if (codenameoneSettingsProperties == null || !codenameoneSettingsProperties.exists()) {
                    throw new MojoExecutionException("Cannot find codenameone_settings.properties");
                }
                SortedProperties cn1Props = new SortedProperties();
                cn1Props.load(new FileReader(codenameoneSettingsProperties));
                cn1Props.putAll((Map<?, ?>)props);
                this.getLog().info((CharSequence)("Injecting properties:\n" + props + "\n into " + codenameoneSettingsProperties));
                cn1Props.store(new FileWriter(codenameoneSettingsProperties), "Injected properties from template");
            }
            if (!(css = this.extractCSS(contents)).isEmpty()) {
                if (!themeCss.exists()) {
                    themeCss.getParentFile().mkdirs();
                }
                this.getLog().info((CharSequence)("Adding CSS to " + themeCss));
                FileUtils.writeStringToFile((File)themeCss, (String)css, (String)"UTF-8");
            }
            if (!(pomContents = pomContents.replace("<codename1.template>", "<codename1.templated.installed>").replace("</codename1.template>", "</codename1.template.installed>")).equals(origPomContents)) {
                this.getLog().info((CharSequence)("Writing changes to " + pomFile));
                FileUtils.writeStringToFile((File)pomFile, (String)pomContents, (String)"UTF-8");
            }
            for (FileContent file : this.extractFiles(contents)) {
                File f = new File(commonProjectDir, file.path);
                f.getParentFile().mkdirs();
                FileUtils.writeStringToFile((File)f, (String)file.content, (String)"UTF-8");
            }
        }
        catch (TemplateParseException ex) {
            throw new MojoExecutionException("Syntax error in template file", (Exception)ex);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to process template file", (Exception)ex);
        }
    }

    private File generateBaseArchetype(String string, File templateFile) throws TemplateParseException, IOException {
        String base;
        String[] requiredProperties;
        Dependency out = new Dependency();
        String archetype = this.extractSectionFrom(string, "archetype");
        Properties props = new Properties();
        props.load(new StringReader(archetype));
        for (String key : requiredProperties = new String[]{"artifactId", "groupId", "version"}) {
            if (props.containsKey(key)) continue;
            throw new TemplateParseException("archetype property " + key + " required and missing.  Make sure it is defined in the [archetype] section of the template");
        }
        File dest = new File(this.outputDir, props.getProperty("artifactId"));
        if (dest.exists()) {
            if (this.overwrite) {
                FileUtils.deleteDirectory((File)dest);
            } else {
                throw new IOException("Project already exists at " + dest + ".  Delete this project before regenerating");
            }
        }
        if ((base = props.getProperty("extends", null)) == null) {
            throw new TemplateParseException("[archetype] section requires the 'extends' property to specify the path to the archetype project that this extends");
        }
        this.baseArchetypeDir = new File(base);
        if (!this.baseArchetypeDir.isAbsolute()) {
            this.baseArchetypeDir = new File(templateFile.getParentFile(), base);
        }
        if (!this.baseArchetypeDir.exists()) {
            throw new IOException("Cannot find archetype project that this template extends.  Looking for it in " + this.baseArchetypeDir);
        }
        if (!new File(this.baseArchetypeDir, "pom.xml").exists()) {
            throw new IOException("Base archetype directory " + this.baseArchetypeDir + " is not a maven project.");
        }
        FileUtils.copyDirectory((File)this.baseArchetypeDir, (File)dest);
        File pomFile = new File(dest, "pom.xml");
        String groupId = null;
        String artifactId = null;
        String version = null;
        if (props.containsKey("id")) {
            String id = props.getProperty("id");
            String[] parts = id.split(":");
            if (parts.length != 3) {
                throw new TemplateParseException("Failed ot parse id property in [archetype] section.  It should be in the format groupId:artifactId:version");
            }
            groupId = parts[0];
            artifactId = parts[1];
            version = parts[2];
        }
        groupId = props.getProperty("groupId", groupId);
        artifactId = props.getProperty("artifactId", artifactId);
        version = props.getProperty("version", version);
        if (groupId == null || artifactId == null || version == null) {
            throw new TemplateParseException("The [archetype] section is required, and must have at least groupId, artifactId, and version defined.  You may also define these using the id property in the format groupId:artifactId:version");
        }
        String parentTag = "";
        String parentGroupId = null;
        String parentArtifactId = null;
        String parentVersion = null;
        if (props.containsKey("parent")) {
            String parent = props.getProperty("parent");
            String[] parts = parent.split(":");
            if (parts.length != 3) {
                throw new TemplateParseException("Failed to parse parent property in [archetype] section. It should be in the format groupId:artifactId:version");
            }
            parentGroupId = parts[0];
            parentArtifactId = parts[1];
            parentVersion = parts[2];
        }
        parentGroupId = props.getProperty("parentGroupId", parentGroupId);
        parentArtifactId = props.getProperty("parentArtifactId", parentArtifactId);
        parentVersion = props.getProperty("parentVersion", parentVersion);
        if (parentGroupId != null && parentVersion != null && parentArtifactId != null) {
            parentTag = "  <parent>\n    <groupId>" + parentGroupId + "</groupId>\n    <artifactId>" + parentArtifactId + "</artifactId>\n    <version>" + parentVersion + "</version>\n  </parent>\n";
        }
        String pomContents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n" + parentTag + "  <groupId>" + groupId + "</groupId>\n  <artifactId>" + artifactId + "</artifactId>\n  <version>" + version + "</version>\n  <packaging>maven-archetype</packaging>\n\n  <name>" + artifactId + "</name>\n\n\n  <build>\n    <extensions>\n      <extension>\n        <groupId>org.apache.maven.archetype</groupId>\n        <artifactId>archetype-packaging</artifactId>\n        <version>3.2.0</version>\n      </extension>\n    </extensions>\n\n    <pluginManagement>\n      <plugins>\n        <plugin>\n          <artifactId>maven-archetype-plugin</artifactId>\n          <version>3.2.0</version>\n        </plugin>\n      </plugins>\n    </pluginManagement>\n  </build>\n\n  <description>Artifact generated using the cn1:generate-archetype goal</description>\n\n  <url>https://www.codenameone.com</url>\n\n  <licenses>\n    <license>\n      <name>GPL v2 With Classpath Exception</name>\n      <url>https://openjdk.java.net/legal/gplv2+ce.html</url>\n      <distribution>repo</distribution>\n      <comments>A business-friendly OSS license</comments>\n    </license>\n  </licenses>\n</project>\n";
        FileUtils.writeStringToFile((File)pomFile, (String)pomContents, (String)"UTF-8");
        return dest;
    }

    private String path(String ... parts) {
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            if (sb.length() > 0) {
                sb.append(File.separator);
            }
            sb.append(part);
        }
        return sb.toString();
    }

    private void processKotlinFile(File tplFile) throws MojoExecutionException {
        try {
            String kotlinContents = FileUtils.readFileToString((File)tplFile, (String)"UTF-8");
            File destProject = this.generateBaseArchetype(kotlinContents, tplFile);
            this.processString(kotlinContents, destProject);
            File archetypeResourcesDir = new File(destProject, this.path("src", "main", "resources", "archetype-resources"));
            File commonDir = new File(archetypeResourcesDir, "common");
            File mainClassFile = new File(commonDir, this.path("src", "main", "kotlin", "__mainName__.kt"));
            this.getLog().info((CharSequence)("Writing Kotlin Source file at " + mainClassFile));
            FileUtils.writeStringToFile((File)mainClassFile, (String)kotlinContents, (String)"UTF-8");
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to load java template file from " + tplFile, (Exception)ex);
        }
        catch (TemplateParseException ex) {
            throw new MojoExecutionException("Failed to parse template from file " + tplFile, (Exception)ex);
        }
    }

    private void processJavaFile(File tplFile) throws MojoExecutionException {
        try {
            String javaContents = FileUtils.readFileToString((File)tplFile, (String)"UTF-8");
            File destProject = this.generateBaseArchetype(javaContents, tplFile);
            this.processString(javaContents, destProject);
            File archetypeResourcesDir = new File(destProject, this.path("src", "main", "resources", "archetype-resources"));
            File commonDir = new File(archetypeResourcesDir, "common");
            File mainClassFile = new File(commonDir, this.path("src", "main", "java", "__mainName__.java"));
            this.getLog().info((CharSequence)("Writing Java Source file at " + mainClassFile));
            FileUtils.writeStringToFile((File)mainClassFile, (String)javaContents, (String)"UTF-8");
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to load java template file from " + tplFile, (Exception)ex);
        }
        catch (TemplateParseException ex) {
            throw new MojoExecutionException("Failed to parse template from file " + tplFile, (Exception)ex);
        }
    }

    private File loadTemplate(String template) throws MojoExecutionException {
        File tplFile = null;
        if (template.startsWith("http://") || template.startsWith("https://")) {
            tplFile = new File(this.project.getBuild().getDirectory() + File.separator + "templates");
            tplFile.mkdirs();
            try {
                URL url = new URL(template);
                tplFile = new File(tplFile, new File(url.getPath()).getName());
                FileUtils.copyURLToFile((URL)url, (File)tplFile);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to download template from " + template, (Exception)ex);
            }
        } else {
            tplFile = new File(template);
        }
        if (!tplFile.exists()) {
            throw new MojoExecutionException("Cannot find template file " + tplFile);
        }
        if (tplFile.isDirectory()) {
            return tplFile;
        }
        if (tplFile.getName().endsWith(".zip")) {
            Expand unzip = (Expand)this.antProject.createTask("unzip");
            unzip.setSrc(tplFile);
            File destFile = new File(this.project.getBuild().getDirectory() + File.separator + tplFile.getName() + "-expanded");
            unzip.setDest(destFile);
            unzip.execute();
            tplFile = destFile;
            if (!tplFile.exists()) {
                throw new MojoExecutionException("Failed to extract template to " + tplFile);
            }
        }
        return tplFile;
    }

    private class FileContent {
        private String path;
        private String content;

        FileContent(String path, String content) {
            this.path = path;
            this.content = content;
        }
    }

    public class TemplateParseException
    extends Exception {
        public TemplateParseException(String message) {
            super(message);
        }
    }
}

