/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.maven.AbstractCN1Mojo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;

@Mojo(name="generate-archetype-projects")
public class GenerateArchetypeProjectsMojo
extends AbstractCN1Mojo {
    @Parameter(property="codename1.generateArchetypes.outputDir", defaultValue="${project.build.directory}/generated-archetypes")
    private File generatedArchetypesOutputDir;
    @Parameter(property="codename1.generateArchetypes.templatesDir", defaultValue="${project.basedir}/archetype-templates")
    private File templatesDir;
    @Parameter(property="codename1.generateArchetypes.overwrite", defaultValue="false")
    private boolean overwrite;
    @Parameter(property="codename1.generateArchetypes.parentGroupId", required=false, defaultValue="com.codenameone")
    private String parentGroupId;
    @Parameter(property="codename1.generateArchetypes.parentArtifactId", required=false, defaultValue="maven-archetypes")
    private String parentArtifactId;
    @Parameter(property="codename1.generateArchetypes.parentVersion", required=false, defaultValue="${project.version}")
    private String parentVersion;
    @Parameter(property="codename1.generateArchetypes.groupId", required=false)
    private String groupId;
    @Parameter(property="codename1.generateArchetypes.artifactId", required=false)
    private String artifactId;
    @Parameter(property="codename1.generateArchetypes.version", required=false, defaultValue="${project.version}")
    private String version;

    @Override
    protected void executeImpl() throws MojoExecutionException, MojoFailureException {
        File[] templates = this.templatesDir.listFiles();
        if (templates != null) {
            for (File template : templates) {
                if (!template.getName().endsWith(".java")) continue;
                this.generateTemplate(template);
            }
            if (this.groupId != null && this.artifactId != null && this.version != null) {
                this.generatedArchetypesOutputDir.mkdirs();
                this.generateParentProject(this.generatedArchetypesOutputDir);
            }
        }
    }

    private void generateTemplate(File template) throws MojoExecutionException {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setGoals(Collections.singletonList("com.codenameone:codenameone-maven-plugin:" + this.getSelf().getVersion() + ":generate-archetype"));
        Properties props = new Properties();
        props.put("template", template.getAbsolutePath());
        if (this.overwrite) {
            props.put("overwrite", "true");
        }
        request.setProperties(props);
        this.generatedArchetypesOutputDir.mkdirs();
        request.setBaseDirectory(this.generatedArchetypesOutputDir);
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            InvocationResult result = invoker.execute((InvocationRequest)request);
            if (result.getExitCode() != 0) {
                throw new MojoExecutionException("Failed to generate project for template " + template, (Exception)result.getExecutionException());
            }
        }
        catch (MavenInvocationException e) {
            throw new MojoExecutionException("Failed to generate archetype project for template " + template, (Exception)((Object)e));
        }
    }

    private List<String> getModuleNames(File directory) {
        ArrayList<String> moduleNames = new ArrayList<String>();
        for (File child : directory.listFiles()) {
            File childPom;
            if (!child.isDirectory() || !(childPom = new File(child, "pom.xml")).exists()) continue;
            moduleNames.add(child.getName());
        }
        return moduleNames;
    }

    private void generateParentProject(File directory) throws MojoFailureException, MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n    \n    <parent>\n        <groupId>" + this.parentGroupId + "</groupId>\n        <artifactId>" + this.parentArtifactId + "</artifactId>\n        <version>" + this.parentVersion + "</version>\n    </parent>\n    <modelVersion>4.0.0</modelVersion>\n    <groupId>" + this.groupId + "</groupId>\n    <artifactId>" + this.artifactId + "</artifactId>\n    <version>" + this.version + "</version>\n    <packaging>pom</packaging>\n    \n    <modules>\n");
        for (String module : this.getModuleNames(directory)) {
            sb.append("<module>").append(module).append("</module>\n");
        }
        sb.append("</modules>\n</project>");
        File pomFile = new File(this.generatedArchetypesOutputDir, "pom.xml");
        if (pomFile.exists() && !this.overwrite) {
            throw new MojoFailureException("Overwrite flag is not set and " + pomFile + " already exists");
        }
        try {
            FileUtils.writeStringToFile((File)pomFile, (String)sb.toString(), (String)"UTF-8");
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to write " + pomFile + ".", (Exception)ex);
        }
    }

    private boolean isSelf(Plugin plugin) {
        return plugin.getArtifactId().equals("codenameone-maven-plugin") && plugin.getGroupId().equals("com.codenameone");
    }

    private Plugin getSelf() {
        for (Plugin p : this.project.getBuildPlugins()) {
            if (!this.isSelf(p)) continue;
            return p;
        }
        return null;
    }
}

