/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.maven.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;

@Mojo(name="generate-cn1lib-project", requiresProject=false)
public class GenerateCn1libProjectMojo
extends AbstractMojo {
    @Parameter(property="sourceProject")
    private File sourceProject;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="version", defaultValue="1.0-SNAPSHOT")
    private String version;
    private Project antProject;

    private void generateProject() throws MojoExecutionException {
        String archetypeVersion = "LATEST";
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read(((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/maven/com.codenameone/codenameone-maven-plugin/pom.xml"));
            archetypeVersion = model.getVersion();
        }
        catch (Exception ex) {
            this.getLog().warn((CharSequence)"Attempted to read archetype version from embedded pom.xml file but failed", (Throwable)ex);
        }
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        archetypeVersion = System.getProperty("cn1Version", archetypeVersion);
        String cn1Version = System.getProperty("cn1Version", null);
        request.setGoals(Collections.singletonList("archetype:generate"));
        String[] propsArr = new String[]{"interactiveMode=false", "archetypeArtifactId=cn1lib-archetype", "archetypeGroupId=com.codenameone", "archetypeVersion=" + archetypeVersion, "artifactId=" + this.artifactId, "groupId=" + this.groupId, "version=" + this.version};
        Properties props = new Properties();
        for (String prop : propsArr) {
            int eqpos = prop.indexOf("=");
            if (eqpos > 0) {
                props.setProperty(prop.substring(0, eqpos), prop.substring(eqpos + 1));
                continue;
            }
            if (eqpos >= 0) continue;
            props.setProperty(prop, "true");
        }
        if (cn1Version != null) {
            props.setProperty("cn1Version", cn1Version);
        }
        request.setShowErrors(true);
        if (this.getLog().isDebugEnabled()) {
            request.setDebug(true);
        }
        request.setProperties(props);
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            InvocationResult result = invoker.execute((InvocationRequest)request);
            if (result.getExitCode() != 0) {
                throw new MojoExecutionException("Failed to generate project using cn1lib-archetype.  Exit code " + result.getExitCode());
            }
        }
        catch (MavenInvocationException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    private File targetProjectDir() {
        return new File(this.artifactId);
    }

    private File targetCommonDir() {
        return new File(this.targetProjectDir(), "common");
    }

    private File targetIosDir() {
        return new File(this.targetProjectDir(), "ios");
    }

    private File targetAndroidDir() {
        return new File(this.targetProjectDir(), "android");
    }

    private File targetJavascriptDir() {
        return new File(this.targetProjectDir(), "javascript");
    }

    private File targetJavaseDir() {
        return new File(this.targetProjectDir(), "javase");
    }

    private File targetWinDir() {
        return new File(this.targetProjectDir(), "win");
    }

    private File targetSrcDir() {
        return new File(this.targetCommonDir(), "src");
    }

    private File targetSrcDir(String type) {
        return new File(this.targetSrcDir(), PathUtil.path("main", type));
    }

    private File sourceSrcDir() {
        return new File(this.sourceProject, "src");
    }

    private File sourceNativeDir() {
        return new File(this.sourceProject, "native");
    }

    private File sourceNativeDir(String type) {
        return new File(this.sourceNativeDir(), type);
    }

    private void copyPropertiesFiles() throws IOException {
        for (File child : this.sourceProject.listFiles()) {
            if (!child.getName().endsWith(".properties")) continue;
            FileUtils.copyFile((File)child, (File)new File(this.targetCommonDir(), child.getName()));
        }
    }

    private boolean hasFilesWithSuffix(File root, String suffix) {
        if (root.isDirectory()) {
            for (File child : root.listFiles()) {
                if (!child.getName().endsWith(suffix)) continue;
                return true;
            }
            for (File child : root.listFiles()) {
                if (!child.isDirectory() || !this.hasFilesWithSuffix(child, suffix)) continue;
                return true;
            }
        }
        return false;
    }

    private void copyIosFiles() {
        if (this.sourceNativeDir("ios").exists()) {
            File srcDir = new File(this.targetIosDir(), PathUtil.path("src", "main", "objectivec"));
            File resDir = new File(this.targetIosDir(), PathUtil.path("src", "main", "resources"));
            Copy copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(srcDir);
            FileSet files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceNativeDir("ios"));
            files.setIncludes("**/*.m, **/*.c, **/*.h");
            copy.addFileset(files);
            copy.execute();
            copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(resDir);
            files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceNativeDir("ios"));
            files.setExcludes("**/*.m, **/*.c, **/*.h");
            copy.addFileset(files);
            copy.execute();
        }
    }

    private void copyAndroidFiles() {
        if (this.sourceNativeDir("android").exists()) {
            File srcDir = new File(this.targetAndroidDir(), PathUtil.path("src", "main", "java"));
            File resDir = new File(this.targetAndroidDir(), PathUtil.path("src", "main", "resources"));
            Copy copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(srcDir);
            FileSet files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceNativeDir("android"));
            files.setIncludes("**/*.java");
            copy.addFileset(files);
            copy.execute();
            copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(resDir);
            files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceNativeDir("android"));
            files.setExcludes("**/*.java");
            copy.addFileset(files);
            copy.execute();
        }
    }

    private void copyJavascriptFiles() {
        if (this.sourceNativeDir("javascript").exists()) {
            File srcDir = new File(this.targetJavascriptDir(), PathUtil.path("src", "main", "javascript"));
            File resDir = new File(this.targetJavascriptDir(), PathUtil.path("src", "main", "resources"));
            Copy copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(srcDir);
            FileSet files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceNativeDir("javascript"));
            files.setIncludes("**/*.js");
            copy.addFileset(files);
            copy.execute();
            copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(resDir);
            files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceNativeDir("javascript"));
            files.setExcludes("**/*.js");
            copy.addFileset(files);
            copy.execute();
        }
    }

    private void copyWinFiles() {
        if (this.sourceNativeDir("win").exists()) {
            File srcDir = new File(this.targetWinDir(), PathUtil.path("src", "main", "csharp"));
            File resDir = new File(this.targetWinDir(), PathUtil.path("src", "main", "resources"));
            Copy copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(srcDir);
            FileSet files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceNativeDir("win"));
            files.setIncludes("**/*.cs");
            copy.addFileset(files);
            copy.execute();
            copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(resDir);
            files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceNativeDir("win"));
            files.setExcludes("**/*.cs");
            copy.addFileset(files);
            copy.execute();
        }
    }

    private File sourceCSSDir() {
        return new File(this.sourceProject, "css");
    }

    private void copyCSSFiles() {
        if (this.sourceCSSDir().exists()) {
            File srcDir = this.targetSrcDir("css");
            Copy copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(srcDir);
            FileSet files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceCSSDir());
            files.setIncludes("**");
            copy.addFileset(files);
            copy.execute();
        }
    }

    private void copyJavaseFiles() {
        if (this.sourceNativeDir("javase").exists()) {
            File srcDir = new File(this.targetJavaseDir(), PathUtil.path("src", "main", "java"));
            File resDir = new File(this.targetJavaseDir(), PathUtil.path("src", "main", "resources"));
            Copy copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(srcDir);
            FileSet files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceNativeDir("javase"));
            files.setIncludes("**/*.java");
            copy.addFileset(files);
            copy.execute();
            copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(resDir);
            files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceNativeDir("javase"));
            files.setExcludes("**/*.java");
            copy.addFileset(files);
            copy.execute();
            for (File child : resDir.listFiles()) {
                if (!child.getName().endsWith(".jar")) continue;
                this.getLog().warn((CharSequence)("Found jar file '" + child.getName() + "' in the native/javase directory.  This has been copied to " + child + ", but you should remove this file and replace it with the equivalent Maven dependency inside your " + new File(this.targetJavaseDir(), "pom.xml") + " file."));
            }
        }
    }

    private void copySourceFiles() {
        Copy copy = (Copy)this.antProject().createTask("copy");
        copy.setTodir(this.targetSrcDir("java"));
        FileSet files = new FileSet();
        files.setProject(this.antProject());
        files.setDir(this.sourceSrcDir());
        files.setIncludes("**/*.java");
        copy.addFileset(files);
        copy.execute();
        copy = (Copy)this.antProject().createTask("copy");
        copy.setTodir(this.targetSrcDir("resources"));
        files = new FileSet();
        files.setProject(this.antProject());
        files.setDir(this.sourceSrcDir());
        files.setExcludes("**/*.kt, **/*.java, **/*.mirah");
        copy.addFileset(files);
        copy.execute();
        if (this.hasFilesWithSuffix(this.sourceSrcDir(), ".kt")) {
            this.targetSrcDir("kotlin").mkdirs();
            copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(this.targetSrcDir("kotlin"));
            files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceSrcDir());
            files.setIncludes("**/*.kt");
            copy.addFileset(files);
            copy.execute();
        }
        if (this.hasFilesWithSuffix(this.sourceSrcDir(), ".mirah")) {
            this.targetSrcDir("mirah").mkdirs();
            copy = (Copy)this.antProject().createTask("copy");
            copy.setTodir(this.targetSrcDir("mirah"));
            files = new FileSet();
            files.setProject(this.antProject());
            files.setDir(this.sourceSrcDir());
            files.setIncludes("**/*.mirah");
            copy.addFileset(files);
            copy.execute();
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.generateProject();
            this.copyPropertiesFiles();
            this.copySourceFiles();
            this.copyAndroidFiles();
            this.copyIosFiles();
            this.copyJavascriptFiles();
            this.copyWinFiles();
            this.copyJavaseFiles();
            this.copyCSSFiles();
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to copy files", (Exception)ex);
        }
    }

    private Project antProject() {
        if (this.antProject == null) {
            this.antProject = new Project();
            this.antProject.setBaseDir(this.sourceProject);
            this.antProject.setDefaultInputStream(System.in);
            DefaultInputHandler handler = new DefaultInputHandler();
            this.antProject.setProjectReference((Object)handler);
            this.antProject.setInputHandler((InputHandler)handler);
            this.antProject.init();
        }
        return this.antProject;
    }
}

