/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.maven.AbstractCN1Mojo;
import com.codename1.maven.PathUtil;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="generate-desktop-app-wrapper")
public class GenerateDesktopAppWrapperMojo
extends AbstractCN1Mojo {
    @Override
    protected void executeImpl() throws MojoExecutionException, MojoFailureException {
        String iconPath = this.properties.getProperty("codename1.icon");
        File iconFile = new File(iconPath);
        if (!iconFile.isAbsolute()) {
            iconFile = new File(this.getCN1ProjectDir(), iconFile.getPath());
        }
        if (!iconFile.exists()) {
            this.getLog().warn((CharSequence)("Icon file " + iconFile + " not found.  Skipping desktop appp icon generation."));
            return;
        }
        File outputDir = new File(this.project.getBuild().getOutputDirectory());
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        try (FileInputStream fis = new FileInputStream(iconFile);){
            this.getLog().debug((CharSequence)"Creating Application Icons");
            BufferedImage iconImage = ImageIO.read(fis);
            this.createIconFile(new File(outputDir, "applicationIconImage_16x16.png"), iconImage, 16, 16);
            this.createIconFile(new File(outputDir, "applicationIconImage_20x20.png"), iconImage, 20, 20);
            this.createIconFile(new File(outputDir, "applicationIconImage_32x32.png"), iconImage, 32, 32);
            this.createIconFile(new File(outputDir, "applicationIconImage_40x40.png"), iconImage, 40, 40);
            this.createIconFile(new File(outputDir, "applicationIconImage_64x64.png"), iconImage, 64, 64);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to generate icons", (Exception)ex);
        }
        File wrapperSources = new File(this.project.getBasedir(), PathUtil.path("src", "desktop", "java"));
        if (wrapperSources.exists()) {
            this.project.addCompileSourceRoot(wrapperSources.getAbsolutePath());
        }
    }

    private void createIconFile(File f, BufferedImage icon, int w, int h) throws IOException {
        ImageIO.write((RenderedImage)this.getScaledInstance(icon, w, h), "png", f);
    }

    private BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight) {
        BufferedImage ret = img;
        int w = img.getWidth();
        int h = img.getHeight();
        if (w < targetWidth && h < targetHeight) {
            BufferedImage b = new BufferedImage(targetWidth, targetHeight, img.getType());
            Graphics2D g2d = b.createGraphics();
            g2d.drawImage(img, 0, 0, targetWidth, targetHeight, null);
            g2d.dispose();
            return b;
        }
        do {
            if (w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, 2);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }
}

