/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.maven.AbstractCN1Mojo;
import com.codename1.maven.PathUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.surefire.shared.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Mojo(name="generate-gui-sources", defaultPhase=LifecyclePhase.INITIALIZE)
public class GenerateGuiSourcesMojo
extends AbstractCN1Mojo {
    private static final String RAD_XML_NAMESPACE = "http://www.codenameone.com/rad";
    private String parentEntityViewClass = "AbstractEntityView";
    private String viewModelType = "Entity";
    private StringBuilder importStatements = new StringBuilder();

    @Override
    protected void executeImpl() throws MojoExecutionException, MojoFailureException {
        if (!this.isCN1ProjectDir()) {
            return;
        }
        if (System.getProperty("generate-gui-sources-done") != null) {
            return;
        }
        System.setProperty("generate-gui-sources-done", "true");
        System.setProperty("javax.xml.bind.context.factory", "com.sun.xml.bind.v2.ContextFactory");
        String buildClientJarPath = PathUtil.path(System.getProperty("user.home"), ".codenameone", "CodeNameOneBuildClient.jar");
        File jarFile = new File(buildClientJarPath);
        if (!jarFile.exists()) {
            throw new MojoExecutionException(buildClientJarPath + " not found at " + jarFile.getAbsolutePath());
        }
        try (URLClassLoader classLoader = new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader());){
            Class<?> clazz = classLoader.loadClass("com.codename1.build.client.GenerateGuiSources");
            Object g = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            clazz.getMethod("setSrcDir", File.class).invoke(g, new File(this.getCN1ProjectDir(), "src" + File.separator + "main" + File.separator + "java"));
            clazz.getMethod("setGuiDir", File.class).invoke(g, new File(this.getCN1ProjectDir(), "src" + File.separator + "main" + File.separator + "guibuilder"));
            clazz.getMethod("execute", new Class[0]).invoke(g, new Object[0]);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to load and execute GenerateGuiSources", e);
        }
        File radViews = this.getRADViewsDirectory();
        this.getLog().debug((CharSequence)("Looking for views in " + radViews));
        if (radViews.isDirectory()) {
            this.project.addCompileSourceRoot(this.getRADGeneratedSourcesDirectory().getAbsolutePath());
            Exception res = GenerateGuiSourcesMojo.forEach(radViews, child -> {
                if (!child.getName().endsWith(".xml")) {
                    return null;
                }
                File destClassFile = this.getDestClassForRADView((File)child);
                this.getLog().debug((CharSequence)("Found view " + child + ".  Checking against " + destClassFile));
                if (!destClassFile.exists() || child.lastModified() > destClassFile.lastModified()) {
                    try {
                        this.generateRADViewClass((File)child);
                    }
                    catch (IOException ex) {
                        return new MojoFailureException("Failed to generate class for RAD fragment XML file " + child, (Throwable)ex);
                    }
                }
                return null;
            });
            if (res != null) {
                if (res instanceof MojoExecutionException) {
                    throw (MojoFailureException)res;
                }
                throw new MojoFailureException("Failed to compile RAD views:" + res.getMessage(), (Throwable)res);
            }
        }
    }

    private File getRADViewsDirectory() {
        return new File(this.getCN1ProjectDir(), PathUtil.path("src", "main", "rad", "views"));
    }

    private File getRADGeneratedSourcesDirectory() {
        return new File(PathUtil.path(this.project.getBuild().getDirectory(), "generated-sources", "rad-views"));
    }

    private static Exception forEach(File root, Function<File, Exception> callback) {
        Exception res = callback.apply(root);
        if (res != null) {
            return res;
        }
        if (root.isDirectory()) {
            for (File child : root.listFiles()) {
                res = GenerateGuiSourcesMojo.forEach(child, callback);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    private File getDestClassForRADView(File viewXMLFile) {
        String ext = viewXMLFile.getName().substring(viewXMLFile.getName().lastIndexOf("."));
        String base = viewXMLFile.getName().substring(0, viewXMLFile.getName().lastIndexOf("."));
        File viewsDirectory = this.getRADViewsDirectory();
        boolean levels = false;
        LinkedList<String> pathParts = new LinkedList<String>();
        for (File f = viewXMLFile.getParentFile(); f != null && !f.equals(viewsDirectory); f = f.getParentFile()) {
            pathParts.addFirst(f.getName());
        }
        StringBuilder pathSb = new StringBuilder();
        for (String part : pathParts) {
            pathSb.append(part).append(File.separator);
        }
        File genSrcDir = new File(this.getRADGeneratedSourcesDirectory(), pathSb.substring(0, pathSb.length() - 1));
        File out = new File(genSrcDir, base + ".java");
        out = new File(out.getParentFile(), "Abstract" + out.getName());
        return out;
    }

    private String getPackageForRADView(File viewXMLFile) {
        String ext = viewXMLFile.getName().substring(viewXMLFile.getName().lastIndexOf("."));
        String base = viewXMLFile.getName().substring(0, viewXMLFile.getName().lastIndexOf("."));
        File viewsDirectory = this.getRADViewsDirectory();
        boolean levels = false;
        LinkedList<String> pathParts = new LinkedList<String>();
        for (File f = viewXMLFile.getParentFile(); f != null && !f.equals(viewsDirectory); f = f.getParentFile()) {
            pathParts.addFirst(f.getName());
        }
        StringBuilder pathSb = new StringBuilder();
        for (String part : pathParts) {
            pathSb.append(part).append(".");
        }
        return pathSb.substring(0, pathSb.length() - 1);
    }

    private void generateRADViewClass(File xmlViewFile) throws IOException {
        this.parentEntityViewClass = "AbstractEntityView";
        this.viewModelType = "Entity";
        this.getLog().debug((CharSequence)("Generating RAD View for XML template " + xmlViewFile));
        StringBuilder sb = new StringBuilder();
        String packageName = this.getPackageForRADView(xmlViewFile);
        String className = xmlViewFile.getName().substring(0, xmlViewFile.getName().indexOf("."));
        className = "Abstract" + className;
        String radViewString = FileUtils.readFileToString((File)xmlViewFile, (String)"utf-8");
        this.generateSchemaFor(xmlViewFile, radViewString);
        radViewString = this.addElementIdentifiersToXML(radViewString);
        if (!packageName.isEmpty()) {
            sb.append("package ").append(packageName).append(";\n");
        }
        sb.append("import com.codename1.rad.annotations.RAD;\n");
        sb.append("import com.codename1.rad.ui.AbstractEntityView;\n");
        sb.append("import com.codename1.rad.ui.EntityView;\n");
        sb.append("import com.codename1.rad.models.Entity;\n");
        sb.append("import com.codename1.rad.nodes.Node;\n");
        sb.append("import com.codename1.io.CharArrayReader;\n");
        sb.append("import com.codename1.rad.ui.ViewContext;\n");
        sb.append((CharSequence)this.importStatements);
        sb.append("@RAD\n");
        String parentClassName = this.parentEntityViewClass;
        if (parentClassName.equals("AbstractEntityView")) {
            parentClassName = parentClassName + "<T>";
        }
        sb.append("public abstract class ").append(className).append("<T extends ").append(this.viewModelType).append(">  extends ").append(parentClassName).append(" {\n");
        sb.append("    private static final String FRAGMENT_XML=\"");
        sb.append(StringEscapeUtils.escapeJava((String)radViewString));
        sb.append("\";\n");
        sb.append("    public ").append(className).append("(ViewContext<T> context) {\n");
        sb.append("        super(context);\n");
        sb.append("    }\n\n");
        sb.append("}\n");
        File destFile = this.getDestClassForRADView(xmlViewFile);
        if (!destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
        }
        this.getLog().debug((CharSequence)("Updating " + destFile));
        FileUtils.writeStringToFile((File)destFile, (String)sb.toString(), (String)"utf-8");
    }

    private void generateSchemaFor(File xmlViewFile, String contents) throws IOException {
        File generatedSources = new File(this.getCN1ProjectDir(), PathUtil.path("target", "generated-sources"));
        File xmlSchemasDirectory = new File(generatedSources, "rad" + File.separator + "xmlSchemas");
        String packageName = this.getPackageForRADView(xmlViewFile);
        String baseName = xmlViewFile.getName();
        baseName = baseName.substring(0, baseName.lastIndexOf("."));
        File actualXsdFile = new File(xmlSchemasDirectory, packageName.replace('.', File.separatorChar) + File.separator + baseName + ".xsd");
        File xsdAliasFile = new File(xmlViewFile.getParentFile(), baseName + ".xsd");
        if (!xsdAliasFile.exists()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\"?>\n");
            sb.append("<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\n");
            sb.append("  <xs:include schemaLocation=\"").append("file://").append(actualXsdFile.getAbsolutePath()).append("\"/>\n");
            sb.append("</xs:schema>\n");
            this.getLog().info((CharSequence)("Writing XSD alias file at " + xsdAliasFile));
            FileUtils.writeStringToFile((File)xsdAliasFile, (String)sb.toString(), (String)"UTF-8");
        }
        if (!contents.contains("xsi:noNamespaceSchemaLocation=\"") || !contents.contains("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"")) {
            String toInject;
            int rootTagStart = contents.indexOf("?>");
            if (rootTagStart < 0) {
                this.getLog().info((CharSequence)("Not adding schema declaration to " + xmlViewFile + " because it failed to find the root element.  The file may be malformed."));
                return;
            }
            if ((rootTagStart = contents.indexOf("<", rootTagStart)) < 0) {
                this.getLog().info((CharSequence)("Not adding schema declaration to " + xmlViewFile + " because it failed to find the root element.  The file may be malformed."));
                return;
            }
            int rootTagEnd = contents.indexOf(">", rootTagStart);
            if (rootTagEnd < 0) {
                this.getLog().info((CharSequence)("Not adding schema declaration to " + xmlViewFile + " because it failed to find the close of the root element. The file may be malformed."));
            }
            String string = toInject = !contents.contains("xsi:noNamespaceSchemaLocation=\"") ? " xsi:noNamespaceSchemaLocation=\"" + baseName + ".xsd\"" : "";
            if (!contents.contains("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"")) {
                toInject = toInject + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
            }
            if (!contents.substring(0, rootTagEnd).contains("xsi:xsi:noNamespaceSchemaLocation") || !contents.substring(0, rootTagEnd).contains("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"")) {
                contents = contents.substring(0, rootTagEnd) + toInject + contents.substring(rootTagEnd);
                FileUtils.writeStringToFile((File)xmlViewFile, (String)contents, (String)"utf-8");
                this.getLog().info((CharSequence)("Injected schema declaration into document element of " + xmlViewFile));
            }
        }
    }

    private String addElementIdentifiersToXML(String xml) throws IOException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(xml.getBytes("utf-8")));
            class Context {
                int index = 0;

                Context() {
                }

                void crawl(Element el) {
                    if (this.index == 0) {
                        if (el.hasAttribute("rad-extends")) {
                            GenerateGuiSourcesMojo.this.parentEntityViewClass = el.getAttribute("rad-extends");
                        }
                        if (el.hasAttribute("rad-model")) {
                            GenerateGuiSourcesMojo.this.viewModelType = el.getAttribute("rad-model");
                        }
                    }
                    if (el.getTagName().equalsIgnoreCase("import")) {
                        GenerateGuiSourcesMojo.this.importStatements.append(el.getTextContent()).append("\n");
                    }
                    el.setAttribute("rad-id", String.valueOf(this.index++));
                    NodeList children = el.getChildNodes();
                    int len = children.getLength();
                    for (int i = 0; i < len; ++i) {
                        Node child = children.item(i);
                        if (!(child instanceof Element)) continue;
                        this.crawl((Element)child);
                    }
                }
            }
            Context ctx = new Context();
            ctx.crawl(doc.getDocumentElement());
            return GenerateGuiSourcesMojo.writeXmlDocumentToString(doc);
        }
        catch (Exception ex) {
            throw new IOException("Failed to parse CodeRAD XML template", ex);
        }
    }

    private static String writeXmlDocumentToString(Document xmlDocument) throws IOException {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer();
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(xmlDocument), new StreamResult(writer));
            String xmlString = writer.getBuffer().toString();
            return xmlString;
        }
        catch (Exception e) {
            throw new IOException("Failed to output CodeRAD as XML document", e);
        }
    }
}

