/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.maven.AbstractCN1Mojo;
import com.codename1.maven.PathUtil;
import com.codename1.maven.StubGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@Mojo(name="generate-native-interfaces")
@Execute(phase=LifecyclePhase.COMPILE)
public class GenerateNativeInterfaces
extends AbstractCN1Mojo {
    @Override
    protected void executeImpl() throws MojoExecutionException, MojoFailureException {
        if (!this.isCN1ProjectDir()) {
            this.getLog().debug((CharSequence)("generate-native-interfaces skipped in directory " + this.project.getBasedir() + " because itis not a codeame one project directory"));
            return;
        }
        File classes = new File(this.project.getBuild().getOutputDirectory());
        final ArrayList failures = new ArrayList();
        try {
            this.scanClasses(classes, new ClassScanner(){

                @Override
                public void usesClass(String cls) {
                }

                @Override
                public void usesClassMethod(String cls, String method) {
                }

                @Override
                public void extendsNativeInterface(String cls) {
                    try {
                        GenerateNativeInterfaces.this.generateNativeInterface(cls);
                    }
                    catch (Exception ex) {
                        GenerateNativeInterfaces.this.getLog().error((CharSequence)("Problem occurred while generating native interface for class " + cls));
                        GenerateNativeInterfaces.this.getLog().error((Throwable)ex);
                        failures.add(ex);
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Failed to generate native interfaces", ex);
        }
        if (!failures.isEmpty()) {
            throw new MojoExecutionException("There were " + failures.size() + " failures while generating native interface stubs. Check the log for details.");
        }
    }

    private void generateNativeInterface(String relativePath) throws Exception {
        ArrayList<URL> classpathUrls;
        if (!relativePath.endsWith(".class")) {
            relativePath = relativePath + ".class";
        }
        File classFile = new File(PathUtil.path(this.project.getBuild().getOutputDirectory(), relativePath.replace(".java", ".class")));
        Class<?> c = null;
        if (classFile.exists()) {
            classpathUrls = new ArrayList<URL>();
            classpathUrls.add(new File(this.project.getBuild().getOutputDirectory()).toURI().toURL());
            File cn1CoreJar = this.getJar("com.codenameone", "codenameone-core");
            if (cn1CoreJar != null) {
                classpathUrls.add(cn1CoreJar.toURI().toURL());
            }
            for (Artifact artifact : this.project.getArtifacts()) {
                File artifactFile;
                if ("provided".equals(artifact.getScope()) || "test".equals(artifact.getScope()) || (artifactFile = this.getJar(artifact)) == null || !artifactFile.exists()) continue;
                classpathUrls.add(artifactFile.toURI().toURL());
            }
        } else {
            throw new IllegalStateException("Project needs to be compiled first");
        }
        URLClassLoader cl = new URLClassLoader(classpathUrls.toArray(new URL[0]));
        String classPath = relativePath.replace("\\", ".").replace("/", ".").replace(File.separator, ".");
        classPath = classPath.substring(0, classPath.lastIndexOf("."));
        c = cl.loadClass(classPath);
        StubGenerator g = StubGenerator.create(this.getLog(), c);
        String s = g.verify();
        if (s != null) {
            throw new RuntimeException("Generation Failed: " + s);
        }
        g.generateCode(this.project.getBasedir().getCanonicalFile().getParentFile(), false);
    }

    private void scanClasses(File directory, final ClassScanner scanner) throws IOException {
        File[] list;
        for (File current : list = directory.listFiles()) {
            if (current.isDirectory()) {
                this.scanClasses(current, scanner);
                continue;
            }
            if (!current.getName().endsWith(".class")) continue;
            FileInputStream is = new FileInputStream(current);
            ClassReader r = null;
            try {
                r = new ClassReader((InputStream)is);
            }
            catch (RuntimeException re) {
                this.getLog().error((CharSequence)("Problem reading class " + current), (Throwable)re);
                throw re;
            }
            ((InputStream)is).close();
            ClassVisitor classVisitor = new ClassVisitor(589824){

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    scanner.usesClass(superName);
                    for (String s : interfaces) {
                        if ("com/codename1/system/NativeInterface".equals(s)) {
                            scanner.extendsNativeInterface(name);
                        }
                        scanner.usesClass(s);
                    }
                    if ("com/codename1/system/NativeInterface".equals(superName)) {
                        scanner.extendsNativeInterface(name);
                    }
                }

                public void visitSource(String string, String string1) {
                }

                public void visitOuterClass(String string, String string1, String string2) {
                }

                public AnnotationVisitor visitAnnotation(String string, boolean bln) {
                    return null;
                }

                public void visitAttribute(Attribute atrbt) {
                }

                public void visitInnerClass(String string, String string1, String string2, int i) {
                }

                public FieldVisitor visitField(int i, String string, String type, String string2, Object o) {
                    if (type.startsWith("L")) {
                        scanner.usesClass(type.substring(1, type.length() - 2));
                    }
                    return null;
                }

                public MethodVisitor visitMethod(int i, String methodName, String string1, String string2, String[] strings) {
                    return new MethodVisitor(589824){

                        public AnnotationVisitor visitAnnotationDefault() {
                            return null;
                        }

                        public AnnotationVisitor visitAnnotation(String string, boolean bln) {
                            return null;
                        }

                        public AnnotationVisitor visitParameterAnnotation(int i, String string, boolean bln) {
                            return null;
                        }

                        public void visitAttribute(Attribute atrbt) {
                        }

                        public void visitCode() {
                        }

                        public void visitFrame(int i, int i1, Object[] os, int i2, Object[] os1) {
                        }

                        public void visitInsn(int i) {
                        }

                        public void visitIntInsn(int i, int i1) {
                        }

                        public void visitVarInsn(int i, int i1) {
                        }

                        public void visitTypeInsn(int i, String string) {
                            scanner.usesClass(string);
                        }

                        public void visitFieldInsn(int i, String string, String string1, String string2) {
                        }

                        public void visitMethodInsn(int i, String owner, String name, String string2) {
                            scanner.usesClass(owner);
                            if (name != null && !name.equals("<init>")) {
                                scanner.usesClassMethod(owner, name);
                            }
                        }

                        public void visitJumpInsn(int i, Label label) {
                        }

                        public void visitLabel(Label label) {
                        }

                        public void visitLdcInsn(Object o) {
                            if (o instanceof Type) {
                                scanner.usesClass(((Type)o).getClassName());
                            }
                        }

                        public void visitIincInsn(int i, int i1) {
                        }

                        public void visitTableSwitchInsn(int i, int i1, Label label, Label[] labels) {
                        }

                        public void visitLookupSwitchInsn(Label label, int[] ints, Label[] labels) {
                        }

                        public void visitMultiANewArrayInsn(String string, int i) {
                        }

                        public void visitTryCatchBlock(Label label, Label label1, Label label2, String string) {
                        }

                        public void visitLocalVariable(String string, String classType, String string2, Label label, Label label1, int i) {
                            if (classType.startsWith("L")) {
                                scanner.usesClass(classType.substring(1, classType.length() - 2));
                            }
                        }

                        public void visitLineNumber(int i, Label label) {
                        }

                        public void visitMaxs(int i, int i1) {
                        }

                        public void visitEnd() {
                        }
                    };
                }

                public void visitEnd() {
                }
            };
            try {
                r.accept(classVisitor, 8);
            }
            catch (RuntimeException re) {
                this.getLog().error((CharSequence)("Error encountered while parsing class " + current.getName()), (Throwable)re);
                throw re;
            }
        }
    }

    private static interface ClassScanner {
        public void usesClass(String var1);

        public void usesClassMethod(String var1, String var2);

        public void extendsNativeInterface(String var1);
    }
}

