/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.maven.AbstractCN1Mojo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;

@Mojo(name="import-ant-project")
public class ImportAntProjectMojo
extends AbstractCN1Mojo {
    private File repository;
    private boolean pomBackedUp;
    public static final String KOTLIN_VERSION = "1.3.72";
    private File sourceProject;

    @Override
    protected void executeImpl() throws MojoExecutionException, MojoFailureException {
        String sourceProjectPath = this.project.getProperties().getProperty("cn1.sourceProject", System.getProperty("cn1.sourceProject"));
        if (sourceProjectPath == null) {
            this.getLog().error((CharSequence)"Please specify the path to the ANT project you wish to import using -Dcn1.sourceProject=/path/to/project");
            throw new MojoExecutionException("Missing cn1.sourceProject parameter");
        }
        this.sourceProject = new File(sourceProjectPath);
        if (!this.sourceProject.exists()) {
            throw new MojoExecutionException("Source project must point to the root directory of a Codename One ant project.  The directory supplied doesn't exist. " + this.sourceProject);
        }
        for (String root : this.project.getCompileSourceRoots()) {
            if (!new File(root).exists()) continue;
            this.getLog().error((CharSequence)"Before you can run the import-ant-project goal, you must delete or rename the source directory in this project.");
            this.getLog().error((CharSequence)("Found existing source directory at " + root));
            throw new MojoExecutionException("Project import failed");
        }
        this.repository = new File(this.project.getBasedir() + File.separator + "repository");
        File tmpDir = new File(this.project.getBuild().getDirectory() + File.separator + "cn1libs");
        File libs = new File(this.sourceProject, "lib");
        for (File cn1lib : libs.listFiles()) {
            if (!cn1lib.getName().endsWith(".cn1lib")) continue;
            this.migrateLib(cn1lib, tmpDir, this.project.getVersion());
        }
        try {
            this.migrateSources();
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)("Failed to migrate sources from " + this.sourceProject + " to " + this.project.getBasedir()));
            throw new MojoExecutionException("Failed to migrate sources", ex);
        }
        if (this.isKotlinProject()) {
            this.addKotlinDependencies();
        }
    }

    private boolean isKotlinProject() {
        return new File(this.sourceProject + File.separator + "lib" + File.separator + "kotlin-runtime.cn1lib").exists();
    }

    private String replaceFirst(String inputString, String pattern, String replacement) {
        int patternLen = pattern.length();
        int index = inputString.indexOf(pattern);
        if (index >= 0) {
            return inputString.substring(0, index) + replacement + inputString.substring(index + patternLen);
        }
        return inputString;
    }

    private void addKotlinDependencies() throws MojoExecutionException {
        File jvmConfig;
        File mvnDir = new File(this.project.getBasedir() + File.separator + ".mvn");
        if (!mvnDir.exists()) {
            mvnDir.mkdir();
        }
        if (!(jvmConfig = new File(mvnDir, "jvm.config")).exists()) {
            try {
                jvmConfig.createNewFile();
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to add .mvn/jvm.config file", (Exception)ex);
            }
        }
        try {
            String contents = FileUtils.readFileToString((File)jvmConfig);
            if (contents.contains("-Dcn1.kotlin=")) {
                contents = contents.replaceAll("-Dcn1\\.kotlin=(true|false)", "");
            }
            contents = contents + " -Dcn1.kotlin=true";
            FileUtils.writeStringToFile((File)jvmConfig, (String)contents);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to update .mvn/jvm.config file", (Exception)ex);
        }
    }

    private void migrateSources() throws Exception {
        File javaSources = new File((String)this.project.getCompileSourceRoots().get(0));
        File antSrcDir = new File(this.sourceProject, "src");
        if (antSrcDir.exists()) {
            File antCSSDirectory;
            Copy copy;
            File kotlinSources = new File(javaSources.getParentFile(), "kotlin");
            javaSources.mkdirs();
            if (javaSources.exists()) {
                copy = (Copy)this.antProject.createTask("copy");
                copy.setOverwrite(true);
                copy.setTodir(javaSources);
                FileSet javaSourcesFilter = new FileSet();
                javaSourcesFilter.setProject(this.antProject);
                javaSourcesFilter.setDir(antSrcDir);
                javaSourcesFilter.setIncludes("**/*.java");
                copy.addFileset(javaSourcesFilter);
                copy.execute();
            }
            if (this.isKotlinProject()) {
                kotlinSources.mkdirs();
                if (kotlinSources.exists()) {
                    copy = (Copy)this.antProject.createTask("copy");
                    copy.setOverwrite(true);
                    copy.setTodir(kotlinSources);
                    FileSet kotlinSourcesFilter = new FileSet();
                    kotlinSourcesFilter.setProject(this.antProject);
                    kotlinSourcesFilter.setDir(antSrcDir);
                    kotlinSourcesFilter.setIncludes("**/*.kt");
                    copy.addFileset(kotlinSourcesFilter);
                    copy.execute();
                }
            }
            File resourcesDir = new File(javaSources.getParentFile(), "resources");
            resourcesDir.mkdirs();
            if (resourcesDir.exists()) {
                Copy copy2 = (Copy)this.antProject.createTask("copy");
                copy2.setOverwrite(true);
                copy2.setTodir(resourcesDir);
                FileSet resourcesFilter = new FileSet();
                resourcesFilter.setProject(this.antProject);
                resourcesFilter.setDir(antSrcDir);
                resourcesFilter.setIncludes("**");
                resourcesFilter.setExcludes("**/*.kt,**/*.java");
                copy2.addFileset(resourcesFilter);
                copy2.execute();
            }
            if ((antCSSDirectory = new File(this.sourceProject, "css")).exists()) {
                File targetCSSDirectory = new File(javaSources.getParentFile(), "css");
                targetCSSDirectory.mkdirs();
                Copy copy3 = (Copy)this.antProject.createTask("copy");
                copy3.setOverwrite(true);
                copy3.setTodir(targetCSSDirectory);
                FileSet resourcesFilter = new FileSet();
                resourcesFilter.setProject(this.antProject);
                resourcesFilter.setDir(antCSSDirectory);
                resourcesFilter.setIncludes("**");
                copy3.addFileset(resourcesFilter);
                copy3.execute();
            }
            File antNativeDirectory = new File(this.sourceProject, "native");
            File nativeDirectory = new File(this.project.getBasedir() + File.separator + "native");
            if (antNativeDirectory.exists()) {
                if (nativeDirectory.exists()) {
                    FileUtils.deleteDirectory((File)nativeDirectory);
                }
                FileUtils.copyDirectory((File)antNativeDirectory, (File)nativeDirectory);
            }
            File srcFile = new File(this.sourceProject, "codenameone_settings.properties");
            File destFile = new File(this.project.getBasedir() + File.separator + srcFile.getName());
            FileUtils.copyFile((File)srcFile, (File)destFile);
        }
        File antResDirectory = new File(this.sourceProject, "res");
        File resDirectory = new File(javaSources.getParentFile(), "res");
        File guibuilderDirectory = new File(javaSources.getParentFile(), "guibuilder");
        if (antResDirectory.exists()) {
            FileUtils.copyDirectory((File)antResDirectory, (File)resDirectory, (boolean)true);
            File guibuilder = new File(resDirectory, "guibuilder");
            if (guibuilder.exists()) {
                FileUtils.copyDirectory((File)guibuilder, (File)guibuilderDirectory, (boolean)true);
                FileUtils.deleteDirectory((File)guibuilder);
            } else {
                guibuilderDirectory.mkdirs();
            }
        } else {
            resDirectory.mkdirs();
            guibuilderDirectory.mkdirs();
        }
        File antTestDirectory = new File(this.sourceProject, "test");
        File javaTestSources = new File(this.project.getBasedir() + File.separator + "src" + File.separator + "test" + File.separator + "java");
        javaTestSources.mkdirs();
        if (antTestDirectory.exists()) {
            Copy copy = (Copy)this.antProject.createTask("copy");
            copy.setTodir(javaTestSources);
            FileSet fs = new FileSet();
            fs.setProject(this.antProject);
            fs.setDir(antTestDirectory);
            fs.setIncludes("**/*.java");
            copy.addFileset(fs);
            copy.execute();
            File kotlinTestSources = new File(javaTestSources.getParentFile(), "kotlin");
            kotlinTestSources.mkdirs();
            copy = (Copy)this.antProject.createTask("copy");
            copy.setTodir(kotlinTestSources);
            fs = new FileSet();
            fs.setProject(this.antProject);
            fs.setDir(antTestDirectory);
            fs.setIncludes("**/*.kt");
            copy.addFileset(fs);
            copy.execute();
            File testResources = new File(javaTestSources.getParentFile(), "resources");
            testResources.mkdirs();
            copy = (Copy)this.antProject.createTask("copy");
            copy.setTodir(testResources);
            fs = new FileSet();
            fs.setProject(this.antProject);
            fs.setDir(antTestDirectory);
            fs.setExcludes("**/*.kt,**/*.java");
            copy.addFileset(fs);
            copy.execute();
        }
    }

    private void migrateLib(File cn1lib, File targetDir, String version) throws MojoExecutionException {
        Manifest manifest;
        Attributes cn1Attributes;
        if (cn1lib.getName().equals("kotlin-runtime.cn1lib")) {
            this.getLog().info((CharSequence)("Skipping migration of " + cn1lib + ".  Will add official kotlin maven dependencies instead."));
            return;
        }
        File outputDir = new File(targetDir, cn1lib.getName().substring(0, cn1lib.getName().lastIndexOf(".")));
        if (outputDir.exists()) {
            this.getLog().info((CharSequence)("Skipping migration of " + cn1lib + ".  The output directory already exists"));
            return;
        }
        Expand unzip = (Expand)this.antProject.createTask("unzip");
        unzip.setSrc(cn1lib);
        unzip.setDest(outputDir);
        unzip.execute();
        File metaInf = new File(outputDir, "META-INF");
        if (!metaInf.exists()) {
            metaInf.mkdir();
        }
        if ((cn1Attributes = (manifest = new Manifest()).getAttributes("cn1lib")) == null) {
            cn1Attributes = new Attributes();
            manifest.getEntries().put("cn1lib", cn1Attributes);
        }
        cn1Attributes.putValue("Version", "1.0");
        File manifestFile = new File(metaInf, "MANIFEST.MF");
        try (FileOutputStream fos = new FileOutputStream(manifestFile);){
            manifest.write(fos);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to create manifest file", (Exception)ex);
        }
        for (File child : outputDir.listFiles()) {
            File metaInfChild = new File(metaInf, "cn1lib" + File.separator + child.getName());
            if (!child.getName().endsWith(".zip") && !child.getName().endsWith(".properties")) continue;
            metaInfChild.getParentFile().mkdirs();
            child.renameTo(metaInfChild);
            if (child.getName().equals("main.zip")) {
                unzip = (Expand)this.antProject.createTask("unzip");
                unzip.setSrc(metaInfChild);
                unzip.setDest(outputDir);
                unzip.execute();
                metaInfChild.delete();
            }
            if (child.getName().equals("stubs.zip")) {
                File sourcesZip = new File(targetDir, outputDir.getName() + "-" + version + "-sources.jar");
                metaInfChild.renameTo(sourcesZip);
            }
            if (child.getName().equals("nativese.zip")) {
                metaInfChild.renameTo(new File(metaInf, "cn1lib" + File.separator + "nativejavase.zip"));
            }
            if (!child.getName().equals("nativeand.zip")) continue;
            metaInfChild.renameTo(new File(metaInf, "cn1lib" + File.separator + "nativeandroid.zip"));
        }
        File outputFile = new File(targetDir, outputDir.getName() + "-" + version + ".jar");
        Zip zip = (Zip)this.antProject.createTask("zip");
        zip.setBasedir(outputDir);
        zip.setDestFile(outputFile);
        zip.execute();
        ImportAntProjectMojo.delTree(outputDir);
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setGoals(Collections.singletonList("install:install-file"));
        request.setBaseDirectory(this.project.getBasedir());
        Properties props = new Properties();
        props.setProperty("file", outputFile.getAbsolutePath());
        props.setProperty("groupId", this.project.getGroupId() + ".cn1libs");
        props.setProperty("artifactId", outputDir.getName());
        props.setProperty("version", version);
        props.setProperty("packaging", "cn1lib");
        props.setProperty("localRepositoryPath", this.repository.getAbsolutePath());
        request.setProperties(props);
        if (!this.repository.exists()) {
            this.getLog().info((CharSequence)("Creating local file system repository to store mavenized cn1libs at " + this.repository));
            this.repository.mkdirs();
        }
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            this.getLog().info((CharSequence)("Installing cn1lib " + outputDir + " into local repository"));
            invoker.execute((InvocationRequest)request);
        }
        catch (MavenInvocationException ex) {
            this.getLog().error((CharSequence)("Failed to install file " + outputFile));
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
        outputFile.delete();
        File pomFile = new File(this.project.getBasedir() + File.separator + "pom.xml");
        if (!pomFile.exists()) {
            throw new MojoExecutionException("Cannot add filesystem repository to pom file because the pom file " + pomFile + " could not be found.");
        }
        try {
            String contents = FileUtils.readFileToString((File)pomFile, (String)"UTF-8");
            boolean changed = false;
            if (!contents.contains("<url>file://${project.basedir}/repository</url>")) {
                changed = true;
                contents = contents.replace("<repositories>", "<repositories>\n<repository>\n        <id>project-repository</id>\n        <url>file://${project.basedir}/repository</url>\n    </repository>\n");
            }
            if (!contents.contains("<artifactId>" + outputDir.getName() + "</artifactId>")) {
                changed = true;
                contents = contents.replaceFirst("</dependencies>", "    <dependency>\n                <groupId>" + this.project.getGroupId() + ".cn1libs</groupId>\n                <artifactId>" + outputDir.getName() + "</artifactId>\n                <version>" + version + "</version>            </dependency>\n        </dependencies>");
            }
            if (changed) {
                if (!this.pomBackedUp) {
                    this.pomBackedUp = true;
                    File pomBackup = new File(pomFile.getAbsolutePath() + "." + System.currentTimeMillis() + ".bak");
                    this.getLog().info((CharSequence)("Backing up pom.xml to " + pomBackup));
                    FileUtils.copyFile((File)pomFile, (File)pomBackup, (boolean)true);
                }
                this.getLog().info((CharSequence)("Adding dependency for library " + outputDir.getName() + " to pom.xml"));
                FileUtils.writeStringToFile((File)pomFile, (String)contents, (String)"UTF-8");
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to read pom file", (Exception)ex);
        }
    }
}

