/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.ant.SortedProperties;
import com.codename1.maven.AbstractCN1Mojo;
import com.codename1.maven.Cn1libUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Expand;

@Mojo(name="installcn1libs", requiresDependencyResolution=ResolutionScope.TEST)
public class InstallCn1libsMojo
extends AbstractCN1Mojo {
    private boolean extractArtifact(Artifact artifact) throws IOException {
        boolean requiresUpdate;
        File cn1libFile = this.findArtifactFile(artifact);
        File destDir = this.getLibDirFor(artifact);
        this.getLog().info((CharSequence)("Extracting cn1lib " + artifact + " to " + destDir));
        boolean bl = requiresUpdate = !destDir.isDirectory() || destDir.lastModified() < cn1libFile.lastModified();
        if ("true".equals(System.getProperty("cn1.updateLibs", null))) {
            requiresUpdate = true;
        }
        if (!requiresUpdate) {
            this.getLog().info((CharSequence)("no update required for " + artifact));
            return false;
        }
        if (destDir.exists()) {
            Delete del = (Delete)this.antProject.createTask("delete");
            del.setDir(destDir);
            del.execute();
        }
        Expand unzip = (Expand)this.antProject.createTask("unzip");
        destDir.mkdirs();
        unzip.setDest(destDir);
        unzip.setSrc(cn1libFile);
        unzip.execute();
        File nativeSeZip = Cn1libUtil.getNativeSEJar(artifact);
        if (nativeSeZip != null && nativeSeZip.exists()) {
            unzip = (Expand)this.antProject.createTask("unzip");
            unzip.setDest(new File(nativeSeZip.getParentFile(), nativeSeZip.getName() + "-extracted"));
            unzip.setSrc(nativeSeZip);
            unzip.execute();
        }
        return true;
    }

    private long getLastModifiedCn1libDependencies() {
        long lastModified = 0L;
        for (Artifact artifact : this.project.getDependencyArtifacts()) {
            lastModified = Math.max(this.getLastModified(artifact), lastModified);
        }
        return lastModified;
    }

    private boolean isProjectUpdateRequired() throws IOException {
        return this.getLastModifiedCn1libDependencies() > this.getLastProjectUpdate();
    }

    private long getLastProjectUpdate() throws IOException {
        String lastUpdated = this.getMavenProperties().getProperty("lastUpdated");
        if (lastUpdated == null) {
            return 0L;
        }
        try {
            return Long.parseLong(lastUpdated);
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    @Override
    public void executeImpl() throws MojoExecutionException, MojoFailureException {
        this.setupCef();
        Exception[] err = new Exception[1];
        ArrayList cn1libArtifacts = new ArrayList();
        this.project.getArtifacts().forEach(artifact -> {
            File jarFile = this.findArtifactFile((Artifact)artifact);
            if (jarFile == null || !Cn1libUtil.isCN1Lib(jarFile)) return;
            cn1libArtifacts.add(artifact);
            try {
                if (!this.extractArtifact((Artifact)artifact)) return;
            }
            catch (IOException ex) {
                err[0] = ex;
            }
        });
        boolean forceUpdate = false;
        if ("true".equals(System.getProperty("cn1.updateLibs", null))) {
            forceUpdate = true;
        }
        try {
            if (forceUpdate || this.isProjectUpdateRequired()) {
                File classesDir = new File(this.project.getBuild().getOutputDirectory());
                InstallCn1libsMojo.delTree(classesDir);
                classesDir.mkdirs();
                this.getLog().info((CharSequence)"Dependencies have changed.  Updating project properties and CSS");
                boolean changed = false;
                for (Artifact artifact2 : this.project.getArtifacts()) {
                    if (this.mergeProjectProperties(artifact2)) {
                        this.getLog().info((CharSequence)("Merged properties for " + artifact2 + " into project properties"));
                        changed = true;
                    }
                    this.getLog().info((CharSequence)("UPdating project css for " + artifact2));
                    this.updateProjectCSS(artifact2);
                }
                if (changed) {
                    this.getLog().info((CharSequence)"Project properties where updated.  Saving changes");
                    this.saveProjectProperties();
                }
                this.saveProjectDependencies();
            }
        }
        catch (IOException ioe) {
            this.getLog().error((CharSequence)"Failed to update project properties and CSS files with new dependencies from pom.xml file.");
            throw new MojoExecutionException("Failed to update project properties and CSS with new dependencies.", (Exception)ioe);
        }
        if (err[0] != null) {
            throw new MojoExecutionException("Failed to extract cn1lib dependencies.", err[0]);
        }
    }

    private boolean mergeProjectProperties(Artifact artifact) throws IOException {
        boolean changed = false;
        if (this.mergeProjectRequiredProperties(artifact)) {
            changed = true;
        }
        if (this.mergeProjectAppendedProperties(artifact)) {
            changed = true;
        }
        return changed;
    }

    private boolean mergeProjectAppendedProperties(Artifact artifact) throws IOException {
        SortedProperties projectProps = this.getProjectProperties();
        SortedProperties libProps = this.getLibraryAppendedProperties(artifact);
        SortedProperties merged = projectProps;
        Enumeration<?> keys = libProps.propertyNames();
        boolean changed = false;
        while (keys.hasMoreElements()) {
            String libval;
            String key = (String)keys.nextElement();
            if (!merged.containsKey(key)) {
                merged.put(key, libProps.getProperty(key));
                changed = true;
                continue;
            }
            String val = merged.getProperty(key);
            if (val.contains(libval = libProps.getProperty(key))) continue;
            merged.put(key, val + libval);
            changed = true;
        }
        return changed;
    }

    private boolean mergeProjectRequiredProperties(Artifact artifact) throws IOException {
        SortedProperties projectProps = this.getProjectProperties();
        SortedProperties libProps = this.getLibraryRequiredProperties(artifact);
        String javaVersion = projectProps.getProperty("codename1.arg.java.version", "8");
        String javaVersionLib = (String)libProps.get("codename1.arg.java.version");
        if (javaVersionLib != null) {
            int v2;
            int v1 = 5;
            if (javaVersion != null) {
                v1 = Integer.parseInt(javaVersion);
            }
            if (v1 < (v2 = Integer.parseInt(javaVersionLib))) {
                throw new BuildException("Cannot use a cn1lib with java version greater then the project java version");
            }
        }
        SortedProperties merged = projectProps;
        Enumeration<?> keys = libProps.propertyNames();
        boolean changed = false;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!merged.containsKey(key)) {
                merged.put(key, libProps.getProperty(key));
                changed = true;
                continue;
            }
            if (merged.get(key).equals(libProps.getProperty(key))) continue;
            throw new BuildException("Property " + key + " has a conflict");
        }
        return changed;
    }

    private File getProjectCSSFile() {
        return new File(this.getProjectCSSDir(), "theme.css");
    }

    private String getProjectCSSFileContents() throws IOException {
        File cssFile = this.getProjectCSSFile();
        byte[] buf = new byte[(int)cssFile.length()];
        try (FileInputStream fis = new FileInputStream(cssFile);){
            int len = fis.read(buf);
        }
        return new String(buf, "UTF-8");
    }

    private String getLibCSSFileContents(Artifact artifact) throws IOException {
        File cssFile = this.getLibCSSFile(artifact);
        byte[] buf = new byte[(int)cssFile.length()];
        try (FileInputStream fis = new FileInputStream(cssFile);){
            int len = fis.read(buf);
        }
        return new String(buf, "UTF-8");
    }

    private File getLibCSSZip(Artifact artifact) throws IOException {
        return new File(this.getLibDirFor(artifact), "META-INF" + File.separator + "cn1lib" + File.separator + "css.zip");
    }

    private File getLibCSSDir(Artifact artifact) throws IOException {
        return new File(this.getLibCSSZip(artifact).getParentFile(), "css");
    }

    private File getLibCSSFile(Artifact artifact) throws IOException {
        return new File(this.getLibCSSDir(artifact), "theme.css");
    }

    private void extractLibCSSDir(Artifact artifact) throws IOException {
        Expand unzip = (Expand)this.antProject.createTask("unzip");
        unzip.setSrc(this.getLibCSSZip(artifact));
        unzip.setDest(this.getLibCSSDir(artifact));
        unzip.execute();
    }

    private String getExistingDependencies() throws IOException {
        return this.getMavenProperties().getProperty("dependencies", "");
    }

    private String getPomDependencies() throws IOException {
        ArrayList deps = new ArrayList();
        this.project.getDependencyArtifacts().forEach(artifact -> {
            File jarFile = this.findArtifactFile((Artifact)artifact);
            if (Cn1libUtil.isCN1Lib(jarFile)) {
                deps.add(artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion());
            }
        });
        Collections.sort(deps);
        StringBuilder sb = new StringBuilder();
        deps.forEach(dep -> sb.append(" ").append((String)dep));
        return sb.toString().trim();
    }

    private void saveProjectDependencies() throws IOException {
        this.getMavenProperties().put("dependencies", this.getPomDependencies());
        this.getMavenProperties().put("lastUpdated", "" + System.currentTimeMillis());
        this.saveMavenProperties();
    }

    public boolean checkDependenciesChanged() throws IOException {
        return !this.getPomDependencies().equals(this.getExistingDependencies());
    }

    private File getLibraryAppendedPropertiesFile(Artifact artifact) {
        File dir = this.getLibDirFor(artifact);
        return new File(dir, "META-INF" + File.separator + "codenameone_library_appended.properties");
    }

    private SortedProperties getLibraryAppendedProperties(Artifact artifact) throws IOException {
        SortedProperties out = new SortedProperties();
        File file = this.getLibraryAppendedPropertiesFile(artifact);
        if (file.exists()) {
            try (FileInputStream fis = new FileInputStream(file);){
                out.load(fis);
            }
        }
        return out;
    }

    private File getLibraryRequiredPropertiesFile(Artifact artifact) {
        File dir = this.getLibDirFor(artifact);
        return new File(dir, "META-INF" + File.separator + "codenameone_library_required.properties");
    }

    private SortedProperties getLibraryRequiredProperties(Artifact artifact) throws IOException {
        SortedProperties out = new SortedProperties();
        File file = this.getLibraryRequiredPropertiesFile(artifact);
        if (file.exists()) {
            try (FileInputStream fis = new FileInputStream(file);){
                out.load(fis);
            }
        }
        return out;
    }

    private void failActivateCSS(Artifact cn1lib) throws IOException {
        throw new IOException("The library " + cn1lib + " cannot be added to this project because it requires CSS.  Please activate CSS in your project before trying to add this library.  \nSee https://www.codenameone.com/manual/css.html for instructions on activating CSS");
    }

    private void updateProjectCSS(Artifact artifact) throws IOException {
        File libCssImpl;
        File cssFile;
        File libCSSFile;
        File libCssDir;
        File cssZip = this.getLibCSSZip(artifact);
        if (!cssZip.exists()) {
            this.getLog().info((CharSequence)(cssZip + " does not exist"));
            this.getLog().info((CharSequence)("Checking if is cn1lib " + artifact.getFile()));
            if (!this.getLibDirFor(artifact).exists() && Cn1libUtil.isCN1Lib(artifact.getFile())) {
                this.getLog().info((CharSequence)"Extracting artifact");
                this.extractArtifact(artifact);
            }
            if (!cssZip.exists()) {
                this.getLog().info((CharSequence)(cssZip + " still doesn't exist"));
                return;
            }
        }
        if (!(libCssDir = this.getLibCSSDir(artifact)).exists()) {
            System.out.println("css dir " + libCssDir + " does not exist yet.  Extracting zip");
            this.extractLibCSSDir(artifact);
        }
        if (!(libCSSFile = this.getLibCSSFile(artifact)).exists()) {
            System.out.println("No theme.css " + libCSSFile + " found");
            return;
        }
        if (!"true".equals(this.getProjectProperties().getProperty("codename1.cssTheme"))) {
            this.failActivateCSS(artifact);
        }
        if (!this.getProjectCSSDir().exists()) {
            this.failActivateCSS(artifact);
        }
        if (!(cssFile = this.getProjectCSSFile()).exists()) {
            this.failActivateCSS(artifact);
        }
        File cssImpl = new File(this.project.getBuild().getDirectory() + File.separator + "css");
        String baseName = artifact.getGroupId() + "__" + artifact.getArtifactId();
        if (!cssImpl.exists()) {
            cssImpl.mkdirs();
        }
        if ((libCssImpl = new File(cssImpl, baseName)).exists()) {
            InstallCn1libsMojo.delTree(libCssImpl);
        }
        libCssImpl.mkdirs();
        Expand unzip = (Expand)this.antProject.createTask("unzip");
        unzip.setSrc(cssZip);
        unzip.setDest(libCssImpl);
        unzip.execute();
    }
}

