/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.maven.AbstractCN1Mojo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.UUID;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.tools.ant.taskdefs.Java;

@Mojo(name="guibuilder")
public class OpenGuiBuilderMojo
extends AbstractCN1Mojo {
    private File guibuilderInput = new File(System.getProperty("user.home") + File.separator + ".guiBuilder" + File.separator + "guibuilder.input");
    @Parameter(property="className", required=true)
    private String className;

    @Override
    protected void executeImpl() throws MojoExecutionException, MojoFailureException {
        if (!this.isCN1ProjectDir()) {
            return;
        }
        try {
            File sourceFile = this.findSourceFile(this.className);
            if (!sourceFile.exists()) {
                throw new MojoExecutionException("Cannot find source file " + sourceFile);
            }
            File guiFile = this.findGuiFile(this.className);
            if (!guiFile.exists()) {
                throw new MojoExecutionException("Cannot find gui fuild " + guiFile);
            }
            File resourceFile = this.getProjectResourceFile();
            if (!resourceFile.exists()) {
                if (this.isCSSProject()) {
                    DefaultInvocationRequest request = new DefaultInvocationRequest();
                    request.setGoals(Collections.singletonList("cn1:css"));
                    DefaultInvoker invoker = new DefaultInvoker();
                    try {
                        this.getLog().info((CharSequence)"theme.res file not found.  Trying to compile CSS to generate it now");
                        invoker.execute((InvocationRequest)request);
                    }
                    catch (MavenInvocationException ex) {
                        this.getLog().error((CharSequence)"Failed to compile CSS");
                        throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
                    }
                    if (!resourceFile.exists()) {
                        throw new MojoExecutionException("Still cannot find resource file at " + resourceFile + " even after compiling project CSS");
                    }
                } else {
                    throw new MojoExecutionException("Cannot find project resource file " + resourceFile);
                }
            }
            this.openInGuiBuilder(this.project.getName(), sourceFile, resourceFile, guiFile);
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"Failed to open form");
            throw new MojoExecutionException("Failed to open form", (Exception)ex);
        }
    }

    private boolean isCSSProject() {
        return "true".equals(this.properties.getProperty("codename1.cssTheme", null));
    }

    private File getProjectResourceFile() {
        if (this.isCSSProject()) {
            return new File(this.project.getBuild().getOutputDirectory() + File.separator + "theme.res");
        }
        return new File(this.project.getBasedir() + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator + "theme.res");
    }

    private File getGuiBuilderSourcesDir() {
        return new File(this.project.getBasedir() + File.separator + "src" + File.separator + "main" + File.separator + "guibuilder");
    }

    private File findGuiFile(String fullyQualifiedClassName) {
        return new File(this.getGuiBuilderSourcesDir(), fullyQualifiedClassName.replace(".", File.separator) + ".gui");
    }

    private File findSourceFile(String fullyQualifiedClassName) {
        return new File(this.project.getBasedir() + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + fullyQualifiedClassName.replace(".", File.separator) + ".java");
    }

    private File getGuiBuilderJar() {
        File home = new File(System.getProperty("user.home"));
        File codenameone = new File(home, ".codenameone");
        File settingsJar = new File(codenameone, "guibuilder.jar");
        return settingsJar;
    }

    static String xmlize(String s) {
        s = s.replace("&", "&amp;");
        s = s.replace("<", "&lt;");
        s = s.replace(">", "&gt;");
        s = s.replace("\"", "&quot;");
        int charCount = s.length();
        for (int iter = 0; iter < charCount; ++iter) {
            char c = s.charAt(iter);
            if (c <= '\u007f') continue;
            StringBuilder b = new StringBuilder();
            for (int counter = 0; counter < charCount; ++counter) {
                c = s.charAt(counter);
                if (c > '\u007f') {
                    b.append("&#x");
                    b.append(Integer.toHexString(c));
                    b.append(";");
                    continue;
                }
                b.append(c);
            }
            return b.toString();
        }
        return s;
    }

    public void openInGuiBuilder(String projectName, final File javaSourceFile, File projectResourceFile, File guiFile) throws IOException, MojoExecutionException {
        try {
            File guiBuilderDirectory = new File(System.getProperty("user.home") + File.separator + ".guiBuilder");
            File cn1Directory = new File(System.getProperty("user.home") + File.separator + ".cn1");
            File codenameOneDirectory = new File(System.getProperty("user.home") + File.separator + ".codenameone");
            guiBuilderDirectory.mkdirs();
            cn1Directory.mkdirs();
            codenameOneDirectory.mkdirs();
            if (!guiBuilderDirectory.exists()) {
                throw new FileNotFoundException("Couldn't find or create the GUI builder directory within your home directory specifically: " + guiBuilderDirectory.getAbsolutePath());
            }
            if (!cn1Directory.exists()) {
                throw new FileNotFoundException("Couldn't find or create the cn1 directory within your home directory specifically: " + cn1Directory.getAbsolutePath());
            }
            if (!codenameOneDirectory.exists()) {
                throw new FileNotFoundException("Couldn't find or create the codename1 directory within your home directory specifically: " + codenameOneDirectory.getAbsolutePath());
            }
            String connectionId = UUID.randomUUID().toString();
            final File runningFile = new File(System.getProperty("user.home") + File.separator + ".guiBuilder" + File.separator + connectionId);
            final File outputFile = new File(System.getProperty("user.home") + File.separator + ".guiBuilder" + File.separator + connectionId + ".ouput");
            runningFile.getParentFile().mkdirs();
            FileOutputStream r = new FileOutputStream(runningFile);
            r.write(0);
            r.close();
            FileOutputStream fos = new FileOutputStream(this.guibuilderInput);
            String formName = javaSourceFile.getName();
            formName = formName.substring(0, formName.length() - 5);
            fos.write(("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<con name=\"" + OpenGuiBuilderMojo.xmlize(projectName) + "\" supportsEvents=\"false\" formName=\"" + OpenGuiBuilderMojo.xmlize(formName) + "\"  file=\"" + OpenGuiBuilderMojo.xmlize(guiFile.toURI().toURL().toExternalForm()) + "\" javaFile=\"" + OpenGuiBuilderMojo.xmlize(javaSourceFile.toURI().toURL().toExternalForm()) + "\" resFile=\"" + OpenGuiBuilderMojo.xmlize(projectResourceFile.toURI().toURL().toExternalForm()) + "\" outputFile=\"" + OpenGuiBuilderMojo.xmlize(outputFile.toURI().toURL().toExternalForm()) + "\" running=\"" + OpenGuiBuilderMojo.xmlize(runningFile.toURI().toURL().toExternalForm()) + "\" />\n").getBytes());
            fos.close();
            this.launchGuiBuilderApp();
            new Thread(){
                private long lastModified = 0L;

                @Override
                public void run() {
                    while (runningFile.exists()) {
                        if (outputFile.exists() && this.lastModified != outputFile.lastModified()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            try {
                                FileInputStream fis = new FileInputStream(outputFile);
                                byte[] data = new byte[(int)outputFile.length()];
                                fis.read(data);
                                fis.close();
                                this.lastModified = outputFile.lastModified();
                                String d = new String(data);
                                if (d.endsWith("DataChangeEvent")) {
                                    OpenGuiBuilderMojo.this.gotoSourceFileLine(javaSourceFile, "void " + d, "\n    public void " + d + "(com.codename1.ui.Component cmp, int type, int index) {\n    }\n");
                                } else if (d.endsWith("Command")) {
                                    OpenGuiBuilderMojo.this.gotoSourceFileLine(javaSourceFile, "void " + d, "\n    public void " + d + "(com.codename1.ui.events.ActionEvent ev, Command cmd) {\n    }\n");
                                } else if (d.endsWith("ListModel")) {
                                    OpenGuiBuilderMojo.this.gotoSourceFileLine(javaSourceFile, "ListModel " + d, "\n    public com.codename1.ui.list.ListModel " + d + "() {\n    }\n");
                                } else {
                                    OpenGuiBuilderMojo.this.gotoSourceFileLine(javaSourceFile, "void " + d, "\n    public void " + d + "(com.codename1.ui.events.ActionEvent ev) {\n    }\n");
                                }
                                outputFile.delete();
                            }
                            catch (IOException err) {
                                err.printStackTrace();
                            }
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }.start();
        }
        catch (IOException err) {
            this.handleGUIBuilderError(err, "Error launching GUI builder: " + err);
        }
    }

    public void gotoSourceFileLine(File javaSource, String methodSig, String methodPrototype) {
    }

    public void handleGUIBuilderError(Exception err, String message) {
    }

    public void launchGuiBuilderApp() throws MojoExecutionException {
        this.updateCodenameOne(false, this.getGuiBuilderJar());
        Java java = this.createJava();
        java.setFork(true);
        if ("true".equals(System.getProperty("spawn", "true"))) {
            java.setSpawn(true);
        }
        java.setJar(this.getGuiBuilderJar());
        java.executeJava();
    }
}

