/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.maven.AbstractCN1Mojo;
import com.codename1.maven.PathUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.tools.ant.taskdefs.Expand;

@Mojo(name="prepare-simulator-classpath", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PrepareSimulatorClasspathMojo
extends AbstractCN1Mojo {
    private boolean filterByName(Artifact artifact) {
        return !"com.codenameone".equals(artifact.getGroupId()) || !"java-runtime".equals(artifact.getArtifactId());
    }

    private String prepareClasspath() {
        StringBuilder sb = new StringBuilder();
        try {
            for (String el : this.project.getRuntimeClasspathElements()) {
                if (sb.length() > 0) {
                    sb.append(File.pathSeparator);
                }
                sb.append(el);
            }
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)"Failed to get runtime classpath elementes", (Throwable)ex);
        }
        return sb.toString();
    }

    @Override
    protected void executeImpl() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Preparing Simulator Classpath");
        Properties props = this.project.getModel().getProperties();
        if (props == null) {
            props = new Properties();
            this.project.getModel().setProperties(props);
        }
        this.project.getModel().addProperty("codename1.mainClass", this.properties.getProperty("codename1.packageName") + "." + this.properties.getProperty("codename1.mainName"));
        if (!this.isCefSetup()) {
            this.getLog().debug((CharSequence)"CEF Not set up yet.  Setting it up now");
            this.setupCef();
        } else {
            this.getLog().debug((CharSequence)("CEF is already set up. cef.dir=" + System.getProperty("cef.dir")));
        }
        this.project.getProperties().setProperty("cef.dir", System.getProperty("cef.dir"));
        File designerJar = this.getDesignerJar();
        if (designerJar == null || !designerJar.exists()) {
            throw new MojoExecutionException("Can't find designer jar");
        }
        this.project.getModel().addProperty("codename1.designer.jar", designerJar.getAbsolutePath());
        File cssFile = new File(this.getCN1ProjectDir(), "src" + File.separator + "main" + File.separator + "css" + File.separator + "theme.css");
        File resFile = new File(this.getCN1ProjectDir(), "target" + File.separator + "classes" + File.separator + "theme.res");
        File mergeFile = new File(this.getCN1ProjectDir(), "target" + File.separator + "css" + File.separator + "theme.css");
        StringBuilder inputs = new StringBuilder();
        this.project.getArtifacts().forEach(artifact -> {
            if (artifact.hasClassifier() && "cn1css".equals(artifact.getClassifier())) {
                File zip = this.findArtifactFile((Artifact)artifact);
                if (zip == null || !zip.exists()) {
                    return;
                }
                File extracted = new File(zip.getParentFile(), zip.getName() + "-extracted");
                this.getLog().debug((CharSequence)("Checking for extracted CSS bundle " + extracted));
                if (extracted.exists() && artifact.isSnapshot() && this.getLastModified((Artifact)artifact) > extracted.lastModified()) {
                    try {
                        FileUtils.deleteDirectory((File)extracted);
                    }
                    catch (IOException ex) {
                        this.getLog().error((Throwable)ex);
                    }
                }
                if (!extracted.exists()) {
                    this.getLog().debug((CharSequence)("CSS bundle " + zip + " not extracted yet.  Extracting to " + extracted));
                    Expand expand = (Expand)this.antProject.createTask("unzip");
                    expand.setSrc(zip);
                    expand.setDest(extracted);
                    expand.execute();
                }
                if (extracted.exists()) {
                    File theme;
                    File extractedCssDir = new File(extracted, PathUtil.path("META-INF", "codenameone", artifact.getGroupId(), artifact.getArtifactId(), "css"));
                    if (extractedCssDir.exists() && (theme = new File(extractedCssDir, "theme.css")).exists()) {
                        if (inputs.length() > 0) {
                            inputs.append(",");
                        }
                        inputs.append(theme.getAbsolutePath());
                    }
                } else {
                    this.getLog().debug((CharSequence)("CSS bundle extraction must have failed for " + zip + " because after extraction it still doesn't exist at " + extracted));
                }
            }
        });
        if (cssFile.exists()) {
            if (inputs.length() > 0) {
                inputs.append(",");
            }
            inputs.append(cssFile.getAbsolutePath());
        }
        if (cssFile.exists()) {
            this.project.getModel().addProperty("codename1.css.compiler.args.input", inputs.toString());
            this.project.getModel().addProperty("codename1.css.compiler.args.output", resFile.getAbsolutePath());
            this.project.getModel().addProperty("codename1.css.compiler.args.merge", mergeFile.getAbsolutePath());
        } else {
            this.project.getModel().addProperty("codename1.css.compiler.args.input", "");
            this.project.getModel().addProperty("codename1.css.compiler.args.output", "");
            this.project.getModel().addProperty("codename1.css.compiler.args.merge", "");
        }
        if ("true".equals(this.project.getProperties().getProperty("cn1.class.path.required"))) {
            this.project.getModel().addProperty("cn1.class.path", this.prepareClasspath());
        }
        Properties simulatorProperties = new Properties();
        File simulatorPropertiesFile = new File(this.getCN1ProjectDir(), PathUtil.path("target", "codenameone", "simulator.properties"));
        if (!simulatorPropertiesFile.getParentFile().exists()) {
            simulatorPropertiesFile.getParentFile().mkdirs();
        }
        try {
            StringBuilder compileClasspath = new StringBuilder();
            for (String el : this.project.getCompileClasspathElements()) {
                if (compileClasspath.length() > 0) {
                    compileClasspath.append(File.pathSeparator);
                }
                compileClasspath.append(el);
            }
            simulatorProperties.setProperty("cn1.maven.compileClasspathElements", compileClasspath.toString());
        }
        catch (Exception compileClasspath) {
            // empty catch block
        }
        try {
            FileOutputStream fos = new FileOutputStream(simulatorPropertiesFile);
            Object object = null;
            try {
                simulatorProperties.store(fos, "Updated simulator properties in PrepareSimulatorClasspathMojo");
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (fos != null) {
                    if (object != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        fos.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to write simulator.properties file", (Exception)ex);
        }
    }

    protected File findCSSDirectory() {
        for (String dir : this.project.getCompileSourceRoots()) {
            File dirFile = new File(dir);
            File cssSibling = new File(dirFile.getParentFile(), "css");
            File themeCss = new File(cssSibling, "theme.css");
            if (!themeCss.exists()) continue;
            return cssSibling;
        }
        return null;
    }
}

