/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.ant.SortedProperties;
import com.codename1.maven.PathUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public class ProjectTemplate {
    private Properties properties;
    private File projectRoot;

    public ProjectTemplate(File projectRoot, Properties properties) {
        this.projectRoot = projectRoot;
        this.properties = properties;
    }

    private boolean isDirectoryEmpty(File directory) {
        int n = 0;
        File[] fileArray = directory.listFiles();
        int n2 = fileArray.length;
        if (n < n2) {
            File child = fileArray[n];
            return true;
        }
        return false;
    }

    public void convertToTemplate(String packageName, String mainName) throws IOException {
        File codenameOneSettings = new File(this.projectRoot, "codenameone_settings.properties");
        SortedProperties settingsProps = new SortedProperties();
        if (codenameOneSettings.exists()) {
            String path;
            File packageDirectory;
            try (FileInputStream fis = new FileInputStream(codenameOneSettings);){
                settingsProps.load(fis);
            }
            settingsProps.put("codename1.packageName", "${packageName}");
            settingsProps.put("codename1.mainName", "${mainName}");
            var7_7 = null;
            try (FileOutputStream fos = new FileOutputStream(codenameOneSettings);){
                settingsProps.store(fos, "Updated packageName and mainName");
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
            File srcDir = new File(this.projectRoot, "src");
            if (srcDir.exists()) {
                this.convertToTemplate(packageName, mainName, srcDir);
            }
            if ((packageDirectory = new File(srcDir, path = packageName.replace('.', File.separatorChar))).exists()) {
                File dest = new File(srcDir, "__packagePath__");
                FileUtils.moveDirectory((File)packageDirectory, (File)dest);
                for (File child : dest.listFiles()) {
                    if (!child.getName().equals(mainName + ".java") && !child.getName().equals(mainName + ".kt") && !child.getName().equals(mainName + ".mirah")) continue;
                    File destMain = new File(dest, "__mainName__" + child.getName().substring(child.getName().lastIndexOf(".")));
                    FileUtils.moveFile((File)child, (File)destMain);
                }
                this.convertToTemplate(packageName, mainName, dest);
            }
            return;
        }
        codenameOneSettings = new File(this.projectRoot, PathUtil.path("common", "codenameone_settings.properties"));
        if (codenameOneSettings.exists()) {
            try (FileInputStream fis = new FileInputStream(codenameOneSettings);){
                settingsProps.load(fis);
            }
            settingsProps.put("codename1.packageName", "${packageName}");
            settingsProps.put("codename1.mainName", "${mainName}");
            var7_8 = null;
            try (FileOutputStream fos = new FileOutputStream(codenameOneSettings);){
                settingsProps.store(fos, "Updated packageName and mainName");
            }
            catch (Throwable throwable) {
                var7_8 = throwable;
                throw throwable;
            }
            for (String lang : new String[]{"java", "kotlin", "mirah", "resources", "rad" + File.separator + "views"}) {
                String path;
                File packageDirectory;
                File srcDir = new File(codenameOneSettings.getParentFile(), PathUtil.path("src", "main", lang));
                if (srcDir.exists()) {
                    this.convertToTemplate(packageName, mainName, srcDir);
                }
                if (!(packageDirectory = new File(srcDir, path = packageName.replace('.', File.separatorChar))).exists()) continue;
                File dest = new File(srcDir, "__packagePath__");
                FileUtils.moveDirectory((File)packageDirectory, (File)dest);
                for (File child : dest.listFiles()) {
                    if (!child.getName().equals(mainName + ".java") && !child.getName().equals(mainName + ".kt") && !child.getName().equals(mainName + ".mirah")) continue;
                    File destMain = new File(dest, "__mainName__" + child.getName().substring(child.getName().lastIndexOf(".")));
                    FileUtils.moveFile((File)child, (File)destMain);
                }
                this.convertToTemplate(packageName, mainName, dest);
            }
            return;
        }
    }

    private void convertToTemplate(String packageName, String mainName, File file) throws IOException {
        if (file.isFile()) {
            String contents;
            String origContents = contents = FileUtils.readFileToString((File)file, (String)"UTF-8");
            if (file.getName().endsWith(".java") || file.getName().endsWith(".kt") || file.getName().endsWith(".mirah")) {
                String pattern = "package " + packageName + "";
                String replacement = "package ${packageName}";
                contents = contents.replace(pattern, replacement);
                pattern = "import " + packageName + ".";
                replacement = "import ${packageName}.";
                contents = contents.replace(pattern, replacement);
                pattern = "class " + mainName + " ";
                replacement = "class ${mainName} ";
                contents = contents.replace(pattern, replacement);
            } else if (file.getAbsolutePath().replace('\\', '.').replace('/', '.').contains("rad.views") && file.getName().endsWith(".xml")) {
                String pattern = "import " + packageName + ".";
                String replacement = "import ${packageName}.";
                contents = contents.replace(pattern, replacement);
                pattern = "=\"" + packageName + "." + mainName;
                replacement = "=\"${packageName}.${mainName}";
                contents = contents.replace(pattern, replacement);
                pattern = "=\"" + packageName + ".";
                replacement = "=\"${packageName}.";
                contents = contents.replace(pattern, replacement);
            }
            if (!contents.equals(origContents)) {
                FileUtils.writeStringToFile((File)file, (String)contents, (String)"UTF-8");
            }
        } else if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.convertToTemplate(packageName, mainName, child);
            }
        }
    }

    public void processFiles() throws IOException {
        this.process(this.projectRoot);
        File cn1SettingsFile = new File(this.projectRoot, "codenameone_settings.properties");
        if (!cn1SettingsFile.exists()) {
            cn1SettingsFile = new File(this.projectRoot, PathUtil.path("common", "codenameone_settings.properties"));
        }
        if (cn1SettingsFile.exists()) {
            SortedProperties props = new SortedProperties();
            try (FileInputStream fis = new FileInputStream(cn1SettingsFile);){
                props.load(fis);
            }
            props.setProperty("codename1.packageName", this.properties.getProperty("packageName"));
            props.setProperty("codename1.mainName", this.properties.getProperty("mainName"));
            var4_4 = null;
            try (FileOutputStream fos = new FileOutputStream(cn1SettingsFile);){
                props.store(fos, "Updated mainName and packageName");
            }
            catch (Throwable throwable) {
                var4_4 = throwable;
                throw throwable;
            }
        }
    }

    public String processContent(String contents) {
        for (String key : this.properties.stringPropertyNames()) {
            if (key.contains(".")) continue;
            contents = contents.replace("${" + key + "}", this.properties.getProperty(key));
        }
        return contents;
    }

    public File processFileName(File file) {
        this.properties.setProperty("packagePath", this.properties.getProperty("packageName").replace('.', File.separatorChar));
        String name = file.getName();
        for (String key : this.properties.stringPropertyNames()) {
            name = name.replace("__" + key + "__", this.properties.getProperty(key));
        }
        if (!name.equals(file.getName())) {
            File dest = new File(file.getParentFile(), name);
            return dest;
        }
        return file;
    }

    private File process(File file) throws IOException {
        if (!this.properties.containsKey("mainName")) {
            throw new IllegalStateException("Properties must contain mainName property");
        }
        if (!this.properties.containsKey("packageName")) {
            throw new IllegalStateException("Properties must contains pacakgeName property");
        }
        this.properties.put("packagePath", this.properties.getProperty("packageName").replace('.', File.separatorChar));
        String name = file.getName();
        if (file.isFile()) {
            File newFile;
            String newContent;
            String contents = FileUtils.readFileToString((File)file, (String)"UTF-8");
            if (!contents.equals(newContent = this.processContent(contents))) {
                FileUtils.writeStringToFile((File)file, (String)newContent, (String)"UTF-8");
            }
            if (!(newFile = this.processFileName(file)).equals(file)) {
                newFile.getParentFile().mkdirs();
                FileUtils.moveFile((File)file, (File)newFile);
                if (this.isDirectoryEmpty(file.getParentFile())) {
                    file.getParentFile().delete();
                }
            }
            return newFile;
        }
        if (file.isDirectory()) {
            File newFile = this.processFileName(file);
            if (!newFile.equals(file)) {
                newFile.getParentFile().mkdirs();
                FileUtils.moveDirectory((File)file, (File)newFile);
                if (this.isDirectoryEmpty(file.getParentFile())) {
                    file.getParentFile().delete();
                }
                file = newFile;
            }
            for (File child : file.listFiles()) {
                File file2 = this.process(child);
            }
            return file;
        }
        return file;
    }
}

