/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import java.io.File;
import java.util.Collections;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;

public class ProjectUtil {
    private final MavenProject project;

    public ProjectUtil(MavenProject project) {
        this.project = project;
    }

    public static ProjectUtil wrap(MavenProject proj) {
        return new ProjectUtil(proj);
    }

    public File getCN1LibProjectDir() {
        File f = new File(this.project.getBasedir(), "codenameone_library_appended.properties");
        if (f.exists()) {
            return this.project.getBasedir();
        }
        for (String srcRoot : this.project.getCompileSourceRoots()) {
            f = new File(srcRoot);
            if (!f.exists() || !f.getParentFile().exists() || !(f = new File(f.getParentFile(), "codenameone_library_appended.properties")).exists()) continue;
            return f.getParentFile();
        }
        return null;
    }

    public File getCN1ProjectDir() {
        File f = new File(this.project.getBasedir(), "codenameone_settings.properties");
        if (f.exists()) {
            return this.project.getBasedir();
        }
        for (String srcRoot : this.project.getCompileSourceRoots()) {
            f = new File(srcRoot);
            if (!f.exists() || !f.getParentFile().exists()) continue;
            if ((f = new File(f.getParentFile(), "codenameone_settings.properties")).exists()) {
                return f.getParentFile();
            }
            if (!(f = new File(f.getParentFile(), "codenameone_library_appended.properties")).exists()) continue;
            return f.getParentFile();
        }
        return null;
    }

    public static void generateHelloWorldProject(File destDir, String groupId) throws MojoExecutionException {
        DefaultInvocationRequest req = new DefaultInvocationRequest();
        req.setGoals(Collections.singletonList("archetype:generate"));
        Properties props = new Properties();
        props.setProperty("archetypeGroupId", "com.codenameone");
        props.setProperty("archetypeArtifactId", "cn1app-archetype");
        String version = System.getProperty("codename1.version");
        if (version == null) {
            throw new IllegalStateException("generateHelloProject requires that the codename1.version System property be set.");
        }
        props.setProperty("archetypeVersion", version);
        props.setProperty("artifactId", destDir.getName());
        props.setProperty("groupId", groupId);
        props.setProperty("version", version);
        props.setProperty("mainName", destDir.getName());
        props.setProperty("interactiveMode", "false");
        req.setProperties(props);
        req.setBaseDirectory(destDir.getParentFile());
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            InvocationResult result = invoker.execute((InvocationRequest)req);
            if (result.getExitCode() != 0) {
                throw new MojoExecutionException("Failed to generate HelloWorld project at " + destDir, (Exception)result.getExecutionException());
            }
        }
        catch (MavenInvocationException ex) {
            throw new MojoExecutionException("Failed to generate HelloWorld project at " + destDir, (Exception)((Object)ex));
        }
    }

    public static void executeGoal(File projectDir, String goalName, String ... properties) throws MojoExecutionException {
        DefaultInvocationRequest req = new DefaultInvocationRequest();
        req.setGoals(Collections.singletonList(goalName));
        Properties props = new Properties();
        props.setProperty("interactiveMode", "false");
        for (String p : properties) {
            int pos = p.indexOf("=");
            if (pos > 0) {
                props.setProperty(p.substring(0, pos), p.substring(pos + 1));
                continue;
            }
            props.setProperty(p, "true");
        }
        req.setProperties(props);
        req.setBaseDirectory(projectDir);
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            InvocationResult result = invoker.execute((InvocationRequest)req);
            if (result.getExitCode() != 0) {
                throw new MojoExecutionException("Failed to run goal " + goalName + " on project project at " + projectDir, (Exception)result.getExecutionException());
            }
        }
        catch (MavenInvocationException ex) {
            throw new MojoExecutionException("Failed to run goal " + goalName + " on project at " + projectDir, (Exception)((Object)ex));
        }
    }
}

