/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.maven.AbstractCN1Mojo;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class RunTestsMojo
extends AbstractCN1Mojo {
    private static final int VERSION = 1;

    private File getMetaDataFile() {
        return new File(this.project.getBuild().getTestOutputDirectory() + File.separator + "tests.dat");
    }

    private boolean isJavaSEProject() {
        return this.project.getArtifactId().endsWith("-javase");
    }

    private boolean isCommonProject() {
        return this.project.getArtifactId().endsWith("-common");
    }

    private File getCommonProjectBaseDir() {
        if (this.isJavaSEProject()) {
            return new File(this.project.getParent().getBasedir(), "common");
        }
        if (this.isCommonProject()) {
            return this.project.getBasedir();
        }
        throw new IllegalStateException("Cannot get common project in this context");
    }

    private boolean prepareTests() throws MojoExecutionException {
        try {
            ArrayList<File> paths = new ArrayList<File>();
            File cn1ProjectDir = this.getCN1ProjectDir();
            paths.add(new File(this.project.getBuild().getTestOutputDirectory()));
            paths.add(new File(this.project.getBuild().getOutputDirectory()));
            for (Artifact artifact : this.project.getArtifacts()) {
                File jar = this.getJar(artifact);
                if (jar != null) {
                    paths.add(jar);
                    continue;
                }
                this.getLog().warn((CharSequence)("Failed to resolve artifact " + artifact));
            }
            Class[] testCases = this.findTestCases(paths.toArray(new File[paths.size()]));
            if (testCases.length == 0) {
                return false;
            }
            File metadataFile = this.getMetaDataFile();
            metadataFile.getParentFile().mkdir();
            DataOutputStream fo = new DataOutputStream(new FileOutputStream(metadataFile));
            Arrays.sort(testCases, new Comparator<Class>(){

                @Override
                public int compare(Class t, Class t1) {
                    return String.CASE_INSENSITIVE_ORDER.compare(t.getName(), t1.getName());
                }
            });
            fo.writeInt(1);
            fo.writeInt(testCases.length);
            for (Class c : testCases) {
                fo.writeUTF(c.getName());
            }
            fo.close();
            return true;
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Failed to prepare tests", ex);
        }
    }

    private Class[] findTestCases(File ... classesDirectories) throws MalformedURLException, IOException {
        Object[] urls = new URL[classesDirectories.length];
        for (int iter = 0; iter < urls.length; ++iter) {
            try {
                urls[iter] = classesDirectories[iter].toURI().toURL();
                continue;
            }
            catch (RuntimeException ex) {
                this.getLog().error((CharSequence)("Failed to add class directory " + iter + " in directory list: " + Arrays.toString(urls)));
                throw ex;
            }
        }
        URLClassLoader cl = new URLClassLoader((URL[])urls);
        File userClassesDirectory = classesDirectories[0];
        ArrayList<Class> classList = new ArrayList<Class>();
        this.findTestCasesInDir(userClassesDirectory.getAbsolutePath(), userClassesDirectory, cl, classList);
        Class[] arr = new Class[classList.size()];
        classList.toArray(arr);
        return arr;
    }

    private void findTestCasesInDir(String baseDir, File directory, URLClassLoader cl, List<Class> classList) throws IOException {
        File[] files = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".class") && file.getName().indexOf(36) < 0 || file.getName().endsWith(".jar");
            }
        });
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                this.findTestCasesInDir(baseDir, f, cl, classList);
                continue;
            }
            String fileName = f.getAbsolutePath();
            if (fileName.endsWith(".jar")) {
                ZipEntry entry;
                FileInputStream zipFile = new FileInputStream(fileName);
                ZipInputStream zip = new ZipInputStream(zipFile);
                while ((entry = zip.getNextEntry()) != null) {
                    String entryName;
                    if (entry.isDirectory() || !(entryName = entry.getName()).endsWith(".class") || entryName.indexOf(36) >= 0) continue;
                    String className = entryName.substring(baseDir.length() + 1, entryName.length() - 6);
                    className = className.replace('/', '.');
                    this.isTestCase(cl, className, classList);
                }
                zip.close();
                continue;
            }
            String className = fileName.substring(baseDir.length() + 1, fileName.length() - 6);
            className = className.replace(File.separatorChar, '.');
            this.isTestCase(cl, className, classList);
        }
    }

    private boolean impl(Class cls) {
        for (Class<?> current : cls.getInterfaces()) {
            if (!current.getName().equals("com.codename1.testing.UnitTest")) continue;
            return true;
        }
        Class parent = cls.getSuperclass();
        if (parent == Object.class || parent == null) {
            return false;
        }
        return this.impl(parent);
    }

    private boolean isTestCase(ClassLoader cl, String className, List<Class> classList) {
        try {
            Class<?> cls = cl.loadClass(className);
            if (Modifier.isAbstract(cls.getModifiers())) {
                return false;
            }
            if (this.impl(cls)) {
                classList.add(cls);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected void executeImpl() throws MojoExecutionException, MojoFailureException {
        this.copyKotlinIncrementalCompileOutputToOutputDir();
        if (!this.prepareTests()) {
            this.getLog().info((CharSequence)"No tests were found.");
            return;
        }
        Java java = this.createJava();
        Path cp = java.createClasspath();
        cp.add(new Path(this.antProject, this.project.getBuild().getTestOutputDirectory()));
        cp.add(new Path(this.antProject, this.project.getBuild().getOutputDirectory()));
        for (Artifact artifact : this.project.getArtifacts()) {
            if ("provided".equals(artifact.getScope())) continue;
            File jar = this.getJar(artifact);
            if (jar != null) {
                cp.add(new Path(this.antProject, jar.getAbsolutePath()));
                continue;
            }
            this.getLog().warn((CharSequence)("Failed to resolve artifact: " + artifact));
        }
        cp.add(new Path(this.antProject, this.getProjectInternalTmpJar().getAbsolutePath()));
        if (!this.isCefSetup()) {
            this.setupCef();
        }
        java.createJvmarg().setValue("-Dcef.dir=" + System.getProperty("cef.dir", System.getProperty("user.home") + File.separator + ".codenameone" + File.separator + "cef"));
        java.setClassname("com.codename1.impl.javase.TestRunner");
        java.createArg().setValue(this.properties.getProperty("codename1.packageName") + "." + this.properties.getProperty("codename1.mainName"));
        java.createArg().setValue("-junitXML");
        File reportsDir = new File(this.project.getBuild().getDirectory(), "cn1-reports");
        reportsDir.mkdirs();
        java.setDir(reportsDir);
        java.setFork(true);
        this.getLog().debug((CharSequence)("Executing Test Runner: " + java.getCommandLine()));
        int result = java.executeJava();
        if (result != 0) {
            throw new MojoExecutionException("Tests failed");
        }
    }
}

