/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.maven.AbstractCN1Mojo;
import com.codename1.maven.Cn1libUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Permissions;

@Mojo(name="simulator", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PACKAGE)
@Execute(phase=LifecyclePhase.COMPILE)
public class SimulatorMojo
extends AbstractCN1Mojo {
    private static final String GROUP_ID = "com.codenameone";
    @Parameter(property="cn1.exec.args")
    private String execArgs;
    private boolean running;

    @Override
    public void executeImpl() throws MojoExecutionException, MojoFailureException {
        File canonicalCn1Project;
        File cn1ProjectDir = this.getCN1ProjectDir();
        File projectDir = this.project.getBasedir();
        if (cn1ProjectDir == null) {
            return;
        }
        try {
            canonicalCn1Project = cn1ProjectDir.getCanonicalFile();
            File canonicalProjectDir = projectDir.getCanonicalFile();
            if (!canonicalCn1Project.equals(canonicalProjectDir)) {
                return;
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Failure trying to compare project paths", (Exception)ioe);
        }
        File javaseProject = new File(canonicalCn1Project.getParentFile(), "javase");
        if (!javaseProject.exists()) {
            throw new MojoExecutionException("JavaSE sibling project is required in order to run the simulator goal.");
        }
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setGoals(Collections.singletonList("verify"));
        request.setBaseDirectory(javaseProject);
        Properties props = new Properties();
        props.setProperty("codename1.platform", "javase");
        request.setProperties(props);
        request.setProfiles(Collections.singletonList("simulator"));
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            invoker.execute((InvocationRequest)request);
        }
        catch (MavenInvocationException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeImpl_old() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("execArgs=" + this.execArgs));
        this.getLog().info((CharSequence)("" + System.getProperties()));
        Java java = this.createJava();
        System.out.println("Setting classpath for java: " + this.prepareClasspath(java));
        java.setClasspath(this.prepareClasspath(java));
        Environment.Variable cn1Classpath = new Environment.Variable();
        cn1Classpath.setKey("cn1.class.path");
        cn1Classpath.setPath(this.prepareClasspath(java));
        java.addSysproperty(cn1Classpath);
        java.setClassname("com.codename1.impl.javase.Simulator");
        if (this.execArgs != null) {
            java.setJvmargs(this.execArgs);
        }
        java.setArgs(this.properties.getProperty("codename1.packageName") + "." + this.properties.getProperty("codename1.mainName"));
        java.setDir(this.getCN1ProjectDir());
        Permissions perms = java.createPermissions();
        Permissions.Permission allPermissions = new Permissions.Permission();
        allPermissions.setClass("java.security.AllPermission");
        perms.addConfiguredGrant(allPermissions);
        java.setFork(true);
        this.running = true;
        try {
            java.executeJava();
        }
        finally {
            this.running = false;
        }
        this.getLog().info((CharSequence)this.antProject.getProperty("stdout"));
    }

    private Path prepareClasspath(Java java) {
        Log log = this.getLog();
        log.debug((CharSequence)"Preparing classpath for Simulator");
        ArrayList paths = new ArrayList();
        Path classpath = java.createClasspath();
        if (System.getProperty("cef.dir") != null) {
            Environment.Variable v = new Environment.Variable();
            v.setKey("cef.dir");
            v.setValue(System.getProperty("cef.dir"));
            java.addSysproperty(v);
        }
        this.copyKotlinIncrementalCompileOutputToOutputDir();
        for (Artifact artifact : this.project.getArtifacts()) {
            File nativeJar;
            log.debug((CharSequence)("Checking artifact " + artifact));
            if ("provided".equals(artifact.getScope()) || "test".equals(artifact.getScope()) || !this.filterByName(artifact)) continue;
            File file = this.getJar(artifact);
            classpath.add(new Path(this.antProject, file.getAbsolutePath()));
            if (Cn1libUtil.isCN1Lib(file) && (nativeJar = Cn1libUtil.getNativeSEJar(artifact)) != null) {
                for (File nativeDepJar : Cn1libUtil.getNativeSEEmbeddedJars(artifact)) {
                    classpath.add(new Path(this.antProject, nativeDepJar.getAbsolutePath()));
                }
            }
            if (this.getProjectInternalTmpJar() == null || !this.getProjectInternalTmpJar().exists()) continue;
            classpath.add(new Path(this.antProject, this.getProjectInternalTmpJar().getAbsolutePath()));
        }
        classpath.add(new Path(this.antProject, this.project.getBuild().getOutputDirectory()));
        log.debug((CharSequence)("Using the following classpath for Stubber: " + classpath));
        return classpath;
    }

    private boolean filterByScope(Artifact artifact) {
        return this.isSupportedScope(artifact.getScope());
    }

    private boolean filterByName(Artifact artifact) {
        return !GROUP_ID.equals(artifact.getGroupId()) || !"java-runtime".equals(artifact.getArtifactId());
    }

    protected boolean isSupportedScope(String scope) {
        switch (scope) {
            case "compile": 
            case "provided": 
            case "system": {
                return true;
            }
        }
        return false;
    }
}

