/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.maven.PathUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.maven.plugin.logging.Log;

public class StubGenerator {
    private Class nativeInterface;
    private File androidFile;
    private File javaseFile;
    private File csFile;
    private File iosHFile;
    private File iosMFile;
    private File jsFile;
    private Log log;

    private StubGenerator() {
    }

    public static StubGenerator create(Log log, Class nativeInterface) {
        StubGenerator instance = new StubGenerator();
        instance.log = log;
        instance.nativeInterface = nativeInterface;
        return instance;
    }

    private boolean isSubinterfaceOfNativeInterface() {
        for (Class<?> current : this.nativeInterface.getInterfaces()) {
            if (!current.getName().equals("com.codename1.system.NativeInterface")) continue;
            return true;
        }
        return false;
    }

    public String verify() {
        if (!this.nativeInterface.isInterface()) {
            return "Not an interface! Native interfaces must be interfaces.";
        }
        if (!this.isSubinterfaceOfNativeInterface()) {
            return "The interface MUST implement NativeInterface!";
        }
        if ((this.nativeInterface.getModifiers() & 1) != 1) {
            return "The interface must be a public interface and not an inner class";
        }
        if (this.nativeInterface.getEnclosingClass() != null) {
            return "The interface must be a public interface and not an inner class";
        }
        Method[] mtds = this.nativeInterface.getMethods();
        int offset = 0;
        for (Method m : mtds) {
            if (m.getExceptionTypes().length > 0) {
                return "Exceptions aren't supported when communicating with native interfaces, in the method " + m.getName();
            }
            if (m.getName().equalsIgnoreCase("init")) {
                return "init() is a reserved method in iOS (a constructor of sort) naming a method init will not work properly.";
            }
            if (!this.isValidType(m.getReturnType())) {
                return "Unsupported return type  " + m.getReturnType().getSimpleName() + " in the method " + m.getName();
            }
            if (!this.checkDuplicateName(mtds, offset)) {
                return "A method with the same name exists for the method " + m.getName() + ", notice that duplicate names (even with different case) aren't supported!";
            }
            ++offset;
            for (Class<?> arg : m.getParameterTypes()) {
                if (this.isValidType(arg)) continue;
                return "Unsupported argument type  " + arg.getSimpleName() + " in the method " + m.getName();
            }
        }
        return null;
    }

    private boolean checkDuplicateName(Method[] mtds, int offset) {
        String name = mtds[offset].getName();
        for (int iter = offset + 1; iter < mtds.length; ++iter) {
            if (!mtds[iter].getName().equalsIgnoreCase(name)) continue;
            return false;
        }
        return true;
    }

    private void initFileNames(File destination) {
        String className = this.nativeInterface.getName().replace('.', File.separatorChar) + "Impl.java";
        this.androidFile = new File(PathUtil.path(destination.getAbsolutePath(), "android", "src", "main", "java", className));
        this.androidFile.getParentFile().mkdirs();
        this.javaseFile = new File(PathUtil.path(destination.getAbsolutePath(), "javase", "src", "main", "java", className));
        this.javaseFile.getParentFile().mkdirs();
        this.csFile = new File(PathUtil.path(destination.getAbsolutePath(), "win", "src", "main", "csharp", this.nativeInterface.getName().replace('.', File.separatorChar) + "Impl.cs"));
        this.csFile.getParentFile().mkdirs();
        String iosFilename = this.nativeInterface.getName().replace('.', '_') + "Impl.";
        this.iosHFile = new File(PathUtil.path(destination.getAbsolutePath(), "ios", "src", "main", "objectivec", iosFilename + "h"));
        this.iosMFile = new File(PathUtil.path(destination.getAbsolutePath(), "ios", "src", "main", "objectivec", iosFilename + "m"));
        this.iosMFile.getParentFile().mkdirs();
        this.jsFile = new File(PathUtil.path(destination.getAbsolutePath(), "javascript", "src", "main", "javascript", this.nativeInterface.getName().replace('.', '_') + ".js"));
        this.jsFile.getParentFile().mkdirs();
    }

    public boolean isFilesExist(File destination) {
        this.initFileNames(destination);
        return this.androidFile.exists() || this.iosHFile.exists() || this.iosMFile.exists() || this.csFile.exists() || this.javaseFile.exists() || this.jsFile.exists();
    }

    public void generateCode(File destination, boolean overwrite) throws IOException {
        this.initFileNames(destination);
        if (overwrite || !this.androidFile.exists()) {
            this.log.info((CharSequence)("Writing " + this.androidFile));
            this.generateJavaFile(this.androidFile, "android.view.View", false);
        } else {
            this.log.debug((CharSequence)(this.androidFile + " already exists. Skipping"));
        }
        if (overwrite || !this.javaseFile.exists()) {
            this.log.info((CharSequence)("Writing " + this.javaseFile));
            this.generateJavaFile(this.javaseFile, "com.codename1.ui.PeerComponent", true);
        } else {
            this.log.debug((CharSequence)(this.javaseFile + " already exists. Skipping"));
        }
        if (overwrite || !this.csFile.exists()) {
            this.log.info((CharSequence)("Writing " + this.csFile));
            this.generateCSFile(this.csFile, "FrameworkElement");
        } else {
            this.log.debug((CharSequence)(this.csFile + " already exists. Skipping"));
        }
        if (overwrite || !this.iosHFile.exists() && !this.iosMFile.exists()) {
            this.log.info((CharSequence)("Writing " + this.iosHFile));
            this.log.info((CharSequence)("Writing " + this.iosMFile));
            this.generateIOSFiles();
        } else {
            this.log.debug((CharSequence)(this.iosHFile + " already exists. Skipping"));
        }
        if (overwrite || !this.jsFile.exists()) {
            this.log.info((CharSequence)("Writing " + this.jsFile));
            this.generateJavaScriptFile();
        } else {
            this.log.debug((CharSequence)(this.jsFile + " already exists. Skipping"));
        }
    }

    private void generateIOSFiles() throws IOException {
        Method[] mtds;
        String h = "#import <Foundation/Foundation.h>\n\n@interface " + this.nativeInterface.getName().replace('.', '_') + "Impl : NSObject {\n}\n\n";
        for (Method m : mtds = this.nativeInterface.getMethods()) {
            h = h + "-(" + this.javaTypeToObjectiveCType(m.getReturnType()) + ")" + m.getName();
            Class<?>[] params = m.getParameterTypes();
            if (params == null || params.length == 0) {
                h = h + ";\n";
                continue;
            }
            h = h + ":(" + this.javaTypeToObjectiveCType(params[0]) + ")param";
            if (params.length == 1) {
                h = h + ";\n";
                continue;
            }
            for (int iter = 1; iter < params.length; ++iter) {
                h = h + " param" + iter + ":(" + this.javaTypeToObjectiveCType(params[iter]) + ")param" + iter;
            }
            h = h + ";\n";
        }
        h = h + "@end\n";
        String m = "#import \"" + this.nativeInterface.getName().replace('.', '_') + "Impl.h\"\n\n@implementation " + this.nativeInterface.getName().replace('.', '_') + "Impl\n\n";
        for (Method mtd : mtds) {
            Class<?> returnType = mtd.getReturnType();
            m = m + "-(" + this.javaTypeToObjectiveCType(returnType) + ")" + mtd.getName();
            Class<?>[] params = mtd.getParameterTypes();
            if (params == null || params.length == 0) {
                m = m + "{\n";
            } else {
                m = m + ":(" + this.javaTypeToObjectiveCType(params[0]) + ")param";
                if (params.length == 1) {
                    m = m + "{\n";
                } else {
                    for (int iter = 1; iter < params.length; ++iter) {
                        m = m + " param" + iter + ":(" + this.javaTypeToObjectiveCType(params[iter]) + ")param" + iter;
                    }
                    m = m + "{\n";
                }
            }
            if (returnType != Void.TYPE && returnType != Void.class) {
                m = returnType == String.class || returnType.getName().equals("com.codename1.ui.PeerComponent") || returnType.isArray() ? m + "    return nil;\n" : (returnType == Boolean.class || returnType == Boolean.TYPE ? m + "    return NO;\n" : m + "    return 0;\n");
            }
            m = m + "}\n\n";
        }
        m = m + "@end\n";
        this.iosHFile.getParentFile().mkdirs();
        FileOutputStream fo = new FileOutputStream(this.iosHFile);
        fo.write(h.getBytes());
        fo.close();
        fo = new FileOutputStream(this.iosMFile);
        fo.write(m.getBytes());
        fo.close();
    }

    private String javaTypeToObjectiveCType(Class t) {
        if (t == String.class) {
            return "NSString*";
        }
        if (t.isArray()) {
            return "NSData*";
        }
        if (t == Integer.class || t == Integer.TYPE) {
            return "int";
        }
        if (Long.class == t || Long.TYPE == t) {
            return "long long";
        }
        if (Byte.class == t || Byte.TYPE == t) {
            return "char";
        }
        if (Short.class == t || Short.TYPE == t) {
            return "short";
        }
        if (Character.class == t || Character.TYPE == t) {
            return "int";
        }
        if (Boolean.class == t || Boolean.TYPE == t) {
            return "BOOL";
        }
        if (Float.class == t || Float.TYPE == t) {
            return "float";
        }
        if (Double.class == t || Double.TYPE == t) {
            return "double";
        }
        if (Void.class == t || Void.TYPE == t) {
            return "void";
        }
        return "void*";
    }

    private String javaTypeToCSharpType(Class t) {
        if (t.getName().equals("com.codename1.ui.PeerComponent")) {
            return "object";
        }
        if (t == String.class) {
            return "string ";
        }
        if (t == Integer.TYPE || t == Integer.class || t == Integer.TYPE) {
            if (t.isArray()) {
                return "int[]";
            }
            return "int";
        }
        if (t == Long.TYPE || Long.class == t || Long.TYPE == t) {
            if (t.isArray()) {
                return "long[]";
            }
            return "long";
        }
        if (t == Byte.TYPE || Byte.class == t || Byte.TYPE == t) {
            if (t.isArray()) {
                return "byte[]";
            }
            return "byte";
        }
        if (t == Short.TYPE || Short.class == t || Short.TYPE == t) {
            if (t.isArray()) {
                return "short[]";
            }
            return "short";
        }
        if (t == Character.TYPE || Character.class == t || Character.TYPE == t) {
            if (t.isArray()) {
                return "char[]";
            }
            return "char";
        }
        if (t == Boolean.TYPE || Boolean.class == t || Boolean.TYPE == t) {
            if (t.isArray()) {
                return "bool[]";
            }
            return "bool";
        }
        if (t == Float.TYPE || Float.class == t || Float.TYPE == t) {
            if (t.isArray()) {
                return "float[]";
            }
            return "float";
        }
        if (t == Double.TYPE || Double.class == t || Double.TYPE == t) {
            if (t.isArray()) {
                return "double[]";
            }
            return "double";
        }
        if (Void.class == t || Void.TYPE == t) {
            return "void";
        }
        return t.getSimpleName();
    }

    private void generateJavaFile(File dest, String peerComponentType, boolean impl) throws IOException {
        Method[] mtds;
        String t = "package " + this.nativeInterface.getPackage().getName() + ";\n\npublic class " + this.nativeInterface.getSimpleName() + "Impl ";
        t = impl ? t + "implements " + this.nativeInterface.getName() + "{\n" : t + "{\n";
        for (Method m : mtds = this.nativeInterface.getMethods()) {
            t = t + "    public ";
            Class<?> returnType = m.getReturnType();
            t = returnType.getName().equals("com.codename1.ui.PeerComponent") ? t + peerComponentType : t + returnType.getSimpleName();
            t = t + " " + m.getName() + "(";
            int offset = 0;
            for (Class<?> arg : m.getParameterTypes()) {
                String s = arg.getSimpleName();
                if (arg.getName().equals("com.codename1.ui.PeerComponent")) {
                    s = peerComponentType;
                }
                t = offset == 0 ? t + s + " param" : t + ", " + s + " param" + offset;
                ++offset;
            }
            t = t + ") {\n";
            if (returnType != Void.TYPE && returnType != Void.class) {
                t = returnType == String.class || returnType.getName().equals("com.codename1.ui.PeerComponent") || returnType.isArray() ? t + "        return null;\n" : (returnType == Boolean.class || returnType == Boolean.TYPE ? t + "        return false;\n" : (returnType == Character.class || returnType == Character.TYPE ? t + "        return (char)0;\n" : (returnType == Byte.class || returnType == Byte.TYPE ? t + "        return (byte)0;\n" : (returnType == Short.class || returnType == Short.TYPE ? t + "        return (short)0;\n" : t + "        return 0;\n"))));
            }
            t = t + "    }\n\n";
        }
        t = t + "}\n";
        dest.getParentFile().mkdirs();
        FileOutputStream fo = new FileOutputStream(dest);
        fo.write(t.getBytes());
        fo.close();
    }

    private void generateCSFile(File dest, String peerComponentType) throws IOException {
        Method[] mtds;
        String t = "namespace " + this.nativeInterface.getPackage().getName() + "{\r\n\r\n\r\npublic class " + this.nativeInterface.getSimpleName() + "Impl : I" + this.nativeInterface.getSimpleName() + "Impl {\r\n";
        for (Method m : mtds = this.nativeInterface.getMethods()) {
            t = t + "    public ";
            Class<?> returnType = m.getReturnType();
            t = t + this.javaTypeToCSharpType(returnType);
            t = t + " " + m.getName() + "(";
            int offset = 0;
            for (Class<?> arg : m.getParameterTypes()) {
                String s = arg.getSimpleName();
                if (arg.getName().equals("com.codename1.ui.PeerComponent")) {
                    s = "object";
                } else if (arg == Boolean.TYPE || arg == Boolean.class || arg == Boolean.TYPE) {
                    s = "bool";
                }
                t = offset == 0 ? t + s + " param" : t + ", " + s + " param" + offset;
                ++offset;
            }
            t = t + ") {\n";
            if (returnType != Void.TYPE && returnType != Void.class) {
                t = returnType == String.class || returnType.getName().equals("com.codename1.ui.PeerComponent") || returnType.isArray() ? t + "        return null;\n" : (returnType == Boolean.class || returnType == Boolean.TYPE ? t + "        return false;\n" : (returnType == Character.class || returnType == Character.TYPE ? t + "        return (char)0;\n" : (returnType == Byte.class || returnType == Byte.TYPE ? t + "        return (byte)0;\n" : (returnType == Short.class || returnType == Short.TYPE ? t + "        return (short)0;\n" : t + "        return 0;\n"))));
            }
            t = t + "    }\n\n";
        }
        t = t + "}\r\n}\r\n";
        dest.getParentFile().mkdirs();
        FileOutputStream fo = new FileOutputStream(dest);
        fo.write(t.getBytes());
        fo.close();
    }

    private boolean isValidType(Class cls) {
        if (cls.isPrimitive()) {
            return true;
        }
        if (cls.isArray()) {
            return cls.getComponentType().isPrimitive();
        }
        if (cls == String.class) {
            return true;
        }
        return cls.getName().equals("com.codename1.ui.PeerComponent");
    }

    private String typeToXMLVMJavaName(Class type) {
        if (type.isArray()) {
            return this.getSimpleNameWithJavaLang(type.getComponentType()).replace('.', '_') + "_1ARRAY";
        }
        return this.getSimpleNameWithJavaLang(type).replace('.', '_');
    }

    private String getSimpleNameWithJavaLang(Class c) {
        if (c.isPrimitive()) {
            return c.getSimpleName();
        }
        if (c.isArray()) {
            return this.getSimpleNameWithJavaLang(c.getComponentType()) + "[]";
        }
        if (c.getClass().getName().startsWith("java.lang.")) {
            return c.getName();
        }
        return c.getSimpleName();
    }

    private void generateJavaScriptFile() throws IOException {
        Method[] mtds;
        String t = "(function(exports){\n\nvar o = {};\n\n";
        for (Method m : mtds = this.nativeInterface.getMethods()) {
            Class<?>[] params;
            t = t + "    o.";
            t = t + m.getName();
            t = t + "_";
            for (Class<?> currentParam : params = m.getParameterTypes()) {
                if (currentParam.getName().equals("com.codename1.ui.PeerComponent")) {
                    t = t + "_com_codename1_ui_PeerComponent";
                    continue;
                }
                t = t + "_";
                t = t + this.typeToXMLVMJavaName(currentParam);
            }
            t = t + " = function(";
            if (params.length > 0) {
                t = t + "param1";
                for (int iter = 2; iter < params.length + 1; ++iter) {
                    t = t + ", param" + iter;
                }
                t = t + ", callback) {\n";
            } else {
                t = t + "callback) {\n";
            }
            t = m.getName().equals("isSupported") ? t + "        callback.complete(false);\n" : t + "        callback.error(new Error(\"Not implemented yet\"));\n";
            t = t + "    };\n\n";
        }
        t = t + "exports.";
        t = t + this.nativeInterface.getName().replace('.', '_');
        t = t + "= o;\n\n})(cn1_get_native_interfaces());\n";
        FileOutputStream fo = new FileOutputStream(this.jsFile);
        fo.write(t.getBytes());
        fo.close();
    }
}

