/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven;

import com.codename1.maven.AbstractCN1Mojo;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.model.Model;
import org.apache.maven.model.jdom.etl.JDomModelETL;
import org.apache.maven.model.jdom.etl.JDomModelETLFactory;
import org.apache.maven.model.jdom.etl.ModelETLRequest;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="update")
public class UpdateCodenameOneMojo
extends AbstractCN1Mojo {
    @Parameter(property="newVersion", defaultValue="")
    private String newVersion;

    @Override
    protected void executeImpl() throws MojoExecutionException, MojoFailureException {
        if (!this.isCN1ProjectDir()) {
            return;
        }
        this.updateCodenameOne(true, new File[0]);
        String existingCn1Version = this.project.getModel().getProperties().getProperty("cn1.version");
        String existingCn1PluginVersion = this.project.getModel().getProperties().getProperty("cn1.plugin.version");
        boolean isAutoVersion = false;
        if ((this.newVersion == null || this.newVersion.isEmpty()) && !existingCn1Version.endsWith("-SNAPSHOT")) {
            this.newVersion = "LATEST";
            isAutoVersion = true;
        }
        if ("LATEST".equals(this.newVersion)) {
            try {
                this.newVersion = this.findLatestVersionOnMavenCentral();
            }
            catch (Exception ex) {
                this.getLog().error((CharSequence)"Failed to find latest version from Maven central", (Throwable)ex);
            }
        }
        this.getLog().info((CharSequence)("Existing cn1.version=" + existingCn1Version));
        this.getLog().info((CharSequence)("Existing cn1.plugin.version=" + existingCn1PluginVersion));
        if (!(this.newVersion == null || this.newVersion.isEmpty() || this.newVersion.equals(existingCn1Version) && this.newVersion.equals(existingCn1PluginVersion))) {
            JDomModelETL modelETL;
            this.getLog().info((CharSequence)("Attempting to update project to version " + this.newVersion));
            Model model = null;
            File pomFile = new File(this.project.getParent().getBasedir(), "pom.xml");
            try {
                ModelETLRequest modelETLRequest = new ModelETLRequest();
                modelETL = new JDomModelETLFactory().newInstance(modelETLRequest);
                modelETL.extract(pomFile);
                model = modelETL.getModel();
            }
            catch (Exception ex) {
                this.getLog().error((CharSequence)"Failed to load pom.xml file from parent project", (Throwable)ex);
                throw new MojoExecutionException("Failed to read pom.xml file", ex);
            }
            boolean changed = false;
            if (!isAutoVersion || !existingCn1Version.endsWith("-SNAPSHOT")) {
                if (!existingCn1Version.equals(this.newVersion)) {
                    this.getLog().info((CharSequence)("Setting cn1.version=" + this.newVersion));
                    model.getProperties().setProperty("cn1.version", this.newVersion);
                    changed = true;
                } else {
                    this.getLog().info((CharSequence)"cn1.version already up to date.  Not changing");
                }
            } else {
                this.getLog().warn((CharSequence)"Not updating cn1.version because current version is a snapshot.  To update cn1.version property run mvn cn1:update -DnewVersion=XXXX");
            }
            if (!isAutoVersion || !existingCn1PluginVersion.endsWith("-SNAPSHOT")) {
                if (!existingCn1PluginVersion.equals(this.newVersion)) {
                    this.getLog().info((CharSequence)("Setting cn1.plugin.version=" + this.newVersion));
                    model.getProperties().setProperty("cn1.plugin.version", this.newVersion);
                    changed = true;
                } else {
                    this.getLog().info((CharSequence)"cn1.plugin.version already up to date. Not changing.");
                }
            } else {
                this.getLog().warn((CharSequence)"Not updating cn1.plugin.version because current version is a snapshot.  To update cn1.plugin.version property, run mvn cn1:update -DnewVersion=XXX");
            }
            if (changed) {
                try {
                    FileUtils.copyFile((File)pomFile, (File)new File(pomFile.getParentFile(), "pom.xml.bak"));
                }
                catch (Exception ex) {
                    throw new MojoExecutionException("Failed to back up pom.xml file", ex);
                }
                try {
                    modelETL.load(pomFile);
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)"Failed to write changes to the pom file", (Throwable)e);
                    throw new MojoExecutionException("Failed to write canges to the pom file.", (Exception)e);
                }
            }
        } else if (this.newVersion == null || this.newVersion.isEmpty()) {
            this.getLog().warn((CharSequence)"Not updating pom.xml file because it is currently set to use a SNAPSHOT version of Codename One.");
            this.getLog().info((CharSequence)"To update to a newer version of CN1 in maven use the -DnewVersion property.");
            this.getLog().info((CharSequence)"e.g. -DnewVersion=LATEST to update to the latest version in Maven central");
            this.getLog().info((CharSequence)"or -DnewVersion=7.0.12, for example");
        } else {
            this.getLog().info((CharSequence)"Maven version already up to date.  Not updating pom.xml file");
        }
    }

    private String findLatestVersionOnMavenCentral() throws IOException, XmlPullParserException {
        URL mavenMetadata = new URL("https://repo1.maven.org/maven2/com/codenameone/codenameone-maven-plugin/maven-metadata.xml");
        MetadataXpp3Reader reader = new MetadataXpp3Reader();
        try (InputStreamReader input = new InputStreamReader(mavenMetadata.openStream(), "UTF-8");){
            Metadata metadata = reader.read((Reader)input, false);
            String string = metadata.getVersioning().getLatest();
            return string;
        }
    }
}

