/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maven.buildWrappers;

import java.io.File;
import java.util.Collections;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;

public abstract class AbstractBuildWrapperMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.project.isExecutionRoot()) {
            this.getLog().info((CharSequence)"Skipping execution for non-root project");
            return;
        }
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(new File("pom.xml"));
        request.setGoals(Collections.singletonList("package"));
        Properties properties = new Properties();
        properties.setProperty("skipTests", "true");
        properties.setProperty("codename1.platform", this.getPlatform());
        if (this.getBuildTarget() != null) {
            properties.setProperty("codename1.buildTarget", this.getBuildTarget());
        }
        request.setProperties(properties);
        if (this.buildExecutableJar()) {
            request.setProfiles(Collections.singletonList("executable-jar"));
        }
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            InvocationResult result = invoker.execute((InvocationRequest)request);
            if (result.getExitCode() != 0) {
                throw new MojoFailureException("Failed to build project with exit code " + result.getExitCode());
            }
        }
        catch (MavenInvocationException e) {
            throw new MojoExecutionException("Failed to invoke Maven", (Exception)((Object)e));
        }
    }

    protected abstract String getPlatform();

    protected abstract String getBuildTarget();

    protected boolean buildExecutableJar() {
        return false;
    }
}

