/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Scanner;

public class RichPropertiesReader {
    public void load(File file, Properties properties) throws IOException, ConfigSyntaxException {
        try (FileInputStream fis = new FileInputStream(file);){
            this.load(fis, properties);
        }
    }

    public void load(InputStream inputStream, Properties properties) throws IOException, ConfigSyntaxException {
        Scanner scanner = new Scanner(inputStream, "UTF-8");
        StringBuilder sb = null;
        String sectionName = null;
        String separator = null;
        int lineNum = 0;
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            ++lineNum;
            if (separator != null && line.equals(separator)) {
                properties.put(sectionName, sb.toString().trim());
                sectionName = null;
                sb = null;
                separator = null;
                continue;
            }
            if (sectionName != null) {
                sb.append(line).append("\n");
                continue;
            }
            if (sectionName == null && line.indexOf("=") > 0 && line.charAt(0) != '[') {
                String key = line.substring(0, line.indexOf("="));
                String value = line.substring(line.indexOf("=") + 1);
                properties.put(key, value);
                continue;
            }
            if (line.length() <= 2) continue;
            char firstChar = line.charAt(0);
            char lastChar = line.charAt(line.length() - 1);
            if (firstChar != '[' || lastChar != ']') continue;
            sectionName = line.substring(1, line.length() - 1);
            if (sectionName.contains("[") || sectionName.contains("]")) {
                sectionName = null;
                continue;
            }
            sb = new StringBuilder();
            if (!scanner.hasNextLine()) {
                throw new ConfigSyntaxException("Missing line after section marker " + sectionName, lineNum);
            }
            String nextLine = scanner.nextLine();
            ++lineNum;
            if (nextLine.length() > 0 && nextLine.charAt(0) == '=') {
                if (this.getSeparatorLength(nextLine) > 0) {
                    separator = nextLine;
                    continue;
                }
                throw new ConfigSyntaxException("Section missing separator " + sectionName, lineNum);
            }
            separator = "";
            sb.append(nextLine).append("\n");
        }
    }

    private int getSeparatorLength(String line) {
        int len = line.length();
        int sepLength = 0;
        for (int i = 0; i < len; ++i) {
            char ch = line.charAt(i);
            if (ch != '=') {
                return -1;
            }
            ++sepLength;
        }
        return sepLength;
    }

    public static class ConfigSyntaxException
    extends Exception {
        private int line;

        public ConfigSyntaxException(String message, int line) {
            super(message);
            this.line = line;
        }
    }
}

