/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.jdom;

import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.jdom.JDomActivationProperty;
import org.apache.maven.model.jdom.JDomBacked;
import org.apache.maven.model.jdom.util.JDomUtils;
import org.jdom2.Element;

public class JDomActivation
extends Activation
implements JDomBacked {
    private final Element jdomElement;

    public JDomActivation(Element jdomElement) {
        this.jdomElement = jdomElement;
        super.setActiveByDefault(Boolean.parseBoolean(JDomUtils.getChildElementTextTrim("activeByDefault", this.jdomElement)));
        super.setJdk(JDomUtils.getChildElementTextTrim("jdk", this.jdomElement));
        Element propertyElement = JDomUtils.getChildElement("property", this.jdomElement);
        if (propertyElement != null) {
            super.setProperty((ActivationProperty)new JDomActivationProperty(propertyElement));
        }
    }

    public void setActiveByDefault(boolean activeByDefault) {
        if (activeByDefault || super.isActiveByDefault()) {
            JDomUtils.rewriteElement("activeByDefault", activeByDefault ? Boolean.TRUE.toString() : null, this.jdomElement);
        }
        super.setActiveByDefault(activeByDefault);
    }

    public ActivationFile getFile() {
        throw new UnsupportedOperationException();
    }

    public void setFile(ActivationFile file) {
        throw new UnsupportedOperationException();
    }

    public void setJdk(String jdk) {
        JDomUtils.rewriteElement("jdk", jdk, this.jdomElement);
        super.setJdk(jdk);
    }

    public ActivationOS getOs() {
        throw new UnsupportedOperationException();
    }

    public void setOs(ActivationOS os) {
        throw new UnsupportedOperationException();
    }

    public void setProperty(ActivationProperty property) {
        if (property == null) {
            JDomUtils.rewriteElement("property", null, this.jdomElement);
        } else {
            String value;
            String name;
            JDomActivationProperty jdomProperty = (JDomActivationProperty)super.getProperty();
            if (jdomProperty == null) {
                Element element = JDomUtils.insertNewElement("property", this.jdomElement);
                jdomProperty = new JDomActivationProperty(element);
            }
            if ((name = property.getName()) != null || jdomProperty.getName() != null) {
                jdomProperty.setName(name);
            }
            if ((value = property.getValue()) != null || jdomProperty.getValue() != null) {
                jdomProperty.setValue(value);
            }
        }
        super.setProperty(property);
    }

    public Activation clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getJDomElement() {
        return this.jdomElement;
    }
}

