/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.jdom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Build;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Resource;
import org.apache.maven.model.jdom.JDomBacked;
import org.apache.maven.model.jdom.JDomExtension;
import org.apache.maven.model.jdom.JDomPluginManagement;
import org.apache.maven.model.jdom.JDomPlugins;
import org.apache.maven.model.jdom.util.JDomUtils;
import org.jdom2.Element;

public class JDomBuild
extends Build
implements JDomBacked {
    private final Element jdomElement;

    public JDomBuild(Element jdomElement) {
        this.jdomElement = jdomElement;
    }

    public String getDefaultGoal() {
        return JDomUtils.getChildElementTextTrim("defaultGoal", this.jdomElement);
    }

    public void setDefaultGoal(String defaultGoal) {
        JDomUtils.rewriteElement("defaultGoal", defaultGoal, this.jdomElement);
    }

    public String getDirectory() {
        return JDomUtils.getChildElementTextTrim("directory", this.jdomElement);
    }

    public void setDirectory(String directory) {
        JDomUtils.rewriteElement("directory", directory, this.jdomElement);
    }

    public List<Extension> getExtensions() {
        Element extensionsElm = this.jdomElement.getChild("extensions", this.jdomElement.getNamespace());
        if (extensionsElm == null) {
            return Collections.emptyList();
        }
        List extensionElms = extensionsElm.getChildren("extension", this.jdomElement.getNamespace());
        ArrayList<Extension> extensions = new ArrayList<Extension>(extensionElms.size());
        for (Element extensionElm : extensionElms) {
            extensions.add(new JDomExtension(extensionElm));
        }
        return extensions;
    }

    public void setExtensions(List<Extension> extensions) {
        throw new UnsupportedOperationException();
    }

    public List<String> getFilters() {
        throw new UnsupportedOperationException();
    }

    public void setFilters(List<String> filters) {
        throw new UnsupportedOperationException();
    }

    public String getFinalName() {
        return JDomUtils.getChildElementTextTrim("finalName", this.jdomElement);
    }

    public void setFinalName(String finalName) {
        JDomUtils.rewriteElement("finalName", finalName, this.jdomElement);
    }

    public String getOutputDirectory() {
        return JDomUtils.getChildElementTextTrim("outputDirectory", this.jdomElement);
    }

    public void setOutputDirectory(String outputDirectory) {
        JDomUtils.rewriteElement("outputDirectory", outputDirectory, this.jdomElement);
    }

    public PluginManagement getPluginManagement() {
        Element pluginManagementElm = this.jdomElement.getChild("pluginManagement", this.jdomElement.getNamespace());
        if (pluginManagementElm == null) {
            return null;
        }
        return new JDomPluginManagement(pluginManagementElm);
    }

    public void setPluginManagement(PluginManagement pluginManagement) {
        throw new UnsupportedOperationException();
    }

    public List<Plugin> getPlugins() {
        Element pluginsElm = this.jdomElement.getChild("plugins", this.jdomElement.getNamespace());
        if (pluginsElm == null) {
            return Collections.emptyList();
        }
        return new JDomPlugins(pluginsElm);
    }

    public void setPlugins(List<Plugin> plugins) {
        if (plugins == null) {
            JDomUtils.rewriteElement("plugins", null, this.jdomElement);
        } else {
            JDomPlugins jdomPlugins = this.getPlugins();
            if (!(jdomPlugins instanceof JDomPlugins)) {
                jdomPlugins = new JDomPlugins(JDomUtils.insertNewElement("plugins", this.jdomElement));
            }
            jdomPlugins.addAll(plugins);
        }
    }

    public List<Resource> getResources() {
        throw new UnsupportedOperationException();
    }

    public void setResources(List<Resource> resources) {
        throw new UnsupportedOperationException();
    }

    public String getScriptSourceDirectory() {
        return JDomUtils.getChildElementTextTrim("scriptSourceDirectory", this.jdomElement);
    }

    public void setScriptSourceDirectory(String scriptSourceDirectory) {
        JDomUtils.rewriteElement("scriptSourceDirectory", scriptSourceDirectory, this.jdomElement);
    }

    public String getSourceDirectory() {
        return JDomUtils.getChildElementTextTrim("sourceDirectory", this.jdomElement);
    }

    public void setSourceDirectory(String sourceDirectory) {
        JDomUtils.rewriteElement("sourceDirectory", sourceDirectory, this.jdomElement);
    }

    public String getTestOutputDirectory() {
        return JDomUtils.getChildElementTextTrim("testOutputDirectory", this.jdomElement);
    }

    public void setTestOutputDirectory(String testOutputDirectory) {
        JDomUtils.rewriteElement("testOutputDirectory", testOutputDirectory, this.jdomElement);
    }

    public List<Resource> getTestResources() {
        throw new UnsupportedOperationException();
    }

    public void setTestResources(List<Resource> testResources) {
        throw new UnsupportedOperationException();
    }

    public String getTestSourceDirectory() {
        return JDomUtils.getChildElementTextTrim("testSourceDirectory", this.jdomElement);
    }

    public void setTestSourceDirectory(String testSourceDirectory) {
        JDomUtils.rewriteElement("testSourceDirectory", testSourceDirectory, this.jdomElement);
    }

    public void flushPluginMap() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Plugin> getPluginsAsMap() {
        throw new UnsupportedOperationException();
    }

    public Build clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getJDomElement() {
        return this.jdomElement;
    }
}

