/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.jdom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.model.jdom.JDomBacked;
import org.apache.maven.model.jdom.util.JDomUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Text;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;

public class JDomConfiguration
extends Xpp3Dom
implements JDomBacked {
    private final Element jdomElement;
    private List<JDomConfiguration> children;

    public JDomConfiguration(Element jdomElement) {
        super(jdomElement.getName());
        this.jdomElement = jdomElement;
        this.children = JDomConfiguration.getChildren(jdomElement);
    }

    private static List<JDomConfiguration> getChildren(Element jdomElement) {
        List childElements = jdomElement.getContent((Filter)new ElementFilter());
        ArrayList<JDomConfiguration> children = new ArrayList<JDomConfiguration>(childElements.size());
        for (Element childElement : childElements) {
            children.add(new JDomConfiguration(childElement));
        }
        return children;
    }

    public void addChild(Xpp3Dom xpp3Dom) {
        this.recAddChild(this.jdomElement, xpp3Dom);
        this.children = JDomConfiguration.getChildren(this.jdomElement);
    }

    private void recAddChild(Element parent, Xpp3Dom child) {
        Element targetChild = JDomUtils.insertNewElement(child.getName(), parent);
        targetChild.setContent((Content)new Text(child.getValue()));
        for (String string : child.getAttributeNames()) {
            targetChild.setAttribute(string, child.getAttribute(string));
        }
        for (String string : child.getChildren()) {
            this.recAddChild(targetChild, (Xpp3Dom)string);
        }
    }

    public String getValue() {
        return this.getJDomElement().getContent().stream().map(Content::getValue).collect(Collectors.joining());
    }

    public void setValue(String value) {
        JDomUtils.rewriteValue(this.jdomElement, value);
    }

    public String[] getAttributeNames() {
        throw new UnsupportedOperationException();
    }

    public String getAttribute(String name) {
        return this.jdomElement.getAttributeValue(name);
    }

    public void setAttribute(String name, String value) {
        throw new UnsupportedOperationException();
    }

    public Xpp3Dom getChild(int i) {
        throw new UnsupportedOperationException();
    }

    public Xpp3Dom getChild(String name) {
        return this.children.stream().filter(c -> name.equals(c.getName())).findFirst().orElse(null);
    }

    public void setConfigurationProperty(String propertyName, String value) {
        Element propertyElement = null;
        for (Element element : this.jdomElement.getContent((Filter)new ElementFilter())) {
            if (!propertyName.equals(element.getName())) continue;
            propertyElement = element;
            break;
        }
        if (propertyElement == null) {
            propertyElement = JDomUtils.insertNewElement(propertyName, this.jdomElement);
            this.children.add(new JDomConfiguration(propertyElement));
        }
        propertyElement.setText(value);
    }

    public Xpp3Dom[] getChildren() {
        return this.children.toArray(new JDomConfiguration[0]);
    }

    public Xpp3Dom[] getChildren(String name) {
        return this.children.stream().filter(c -> name.equals(c.getName())).collect(Collectors.toList()).toArray(new Xpp3Dom[0]);
    }

    public int getChildCount() {
        throw new UnsupportedOperationException();
    }

    public void removeChild(int i) {
        throw new UnsupportedOperationException();
    }

    public Xpp3Dom getParent() {
        throw new UnsupportedOperationException();
    }

    public void setParent(Xpp3Dom parent) {
        throw new UnsupportedOperationException();
    }

    public void writeToSerializer(String namespace, XmlSerializer serializer) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toUnescapedString() {
        throw new UnsupportedOperationException();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "JDomConfiguration{jdomElement=" + this.jdomElement + '}';
    }

    @Override
    public Element getJDomElement() {
        return this.jdomElement;
    }
}

