/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.jdom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.jdom.JDomBacked;
import org.apache.maven.model.jdom.JDomDependency;
import org.apache.maven.model.jdom.JDomDependencyManagement;
import org.apache.maven.model.jdom.util.JDomUtils;
import org.codehaus.plexus.util.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;

public class JDomDependencies
extends ArrayList<Dependency>
implements JDomBacked {
    private final Element jdomElement;
    private final JDomBacked parent;

    public JDomDependencies(Element jdomElement, JDomBacked parent) {
        super(JDomDependencies.transformDependencyElementsToJDomDependencyList(jdomElement));
        this.jdomElement = jdomElement;
        this.parent = parent;
    }

    private static List<JDomDependency> transformDependencyElementsToJDomDependencyList(Element jdomElement) {
        ElementFilter dependencyElementFilter = new ElementFilter("dependency", jdomElement.getNamespace());
        List dependencyElements = jdomElement.getContent((Filter)dependencyElementFilter);
        ArrayList<JDomDependency> jDomDependencyList = new ArrayList<JDomDependency>(dependencyElements.size());
        for (Element dependencyElement : dependencyElements) {
            jDomDependencyList.add(new JDomDependency(dependencyElement));
        }
        return jDomDependencyList;
    }

    @Override
    public boolean add(Dependency dependency) {
        this.add(this.size(), dependency);
        return true;
    }

    @Override
    public boolean remove(Object dependency) {
        Dependency removeDependency = (Dependency)dependency;
        for (Dependency candidate : this) {
            if (!StringUtils.equals((String)candidate.getGroupId(), (String)removeDependency.getGroupId()) || !StringUtils.equals((String)candidate.getArtifactId(), (String)removeDependency.getArtifactId()) || !StringUtils.defaultString((Object)candidate.getType(), (String)"jar").equals(StringUtils.defaultString((Object)removeDependency.getType(), (String)"jar"))) continue;
            JDomUtils.removeChildAndItsCommentFromContent(this.jdomElement, (Content)((JDomDependency)candidate).getJDomElement());
            boolean remove = super.remove(candidate);
            if (super.isEmpty()) {
                if (this.parent instanceof JDomDependencyManagement) {
                    JDomBacked parentOfDependencyManagement = ((JDomDependencyManagement)this.parent).getParent();
                    JDomUtils.removeChildAndItsCommentFromContent(parentOfDependencyManagement.getJDomElement(), (Content)this.parent.getJDomElement());
                } else {
                    JDomUtils.removeChildAndItsCommentFromContent(this.parent.getJDomElement(), (Content)this.jdomElement);
                }
            }
            return remove;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends Dependency> dependencies) {
        boolean added = false;
        for (Dependency dependency : dependencies) {
            added |= this.add(dependency);
        }
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Dependency> dependencies) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> dependencies) {
        boolean result = false;
        for (Object dependency : dependencies) {
            result |= this.remove(dependency);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> dependencies) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        while (this.size() > 0) {
            this.remove(0);
        }
    }

    @Override
    public Dependency set(int index, Dependency dependency) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, Dependency dependency) {
        JDomDependency jdomDependency;
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        int elementIndex = index;
        if (index > 0) {
            Element previousElement = ((JDomDependency)this.get(index - 1)).getJDomElement();
            elementIndex = 1 + JDomUtils.getElementIndex(previousElement, this.jdomElement);
        }
        if (this.jdomElement.getParent() == null) {
            JDomUtils.addElement(this.jdomElement, this.parent.getJDomElement());
        }
        if (this.parent instanceof JDomDependencyManagement && this.parent.getJDomElement().getParent() == null) {
            JDomUtils.addElement(this.parent.getJDomElement(), ((JDomDependencyManagement)this.parent).getParent().getJDomElement());
        }
        if (dependency instanceof JDomDependency) {
            jdomDependency = (JDomDependency)dependency;
            JDomUtils.addElement(jdomDependency.getJDomElement().clone(), this.jdomElement, elementIndex);
        } else {
            Element newElement = JDomUtils.insertNewElement("dependency", this.jdomElement, elementIndex);
            jdomDependency = new JDomDependency(newElement, dependency);
        }
        super.add(index, jdomDependency);
    }

    @Override
    public Dependency remove(int index) {
        Dependency dependency = (Dependency)this.get(index);
        this.remove(dependency);
        return dependency;
    }

    @Override
    public int lastIndexOf(Object dependency) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Dependency> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Dependency> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Dependency> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getJDomElement() {
        return this.jdomElement;
    }
}

