/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.jdom;

import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.jdom.JDomBacked;
import org.apache.maven.model.jdom.util.JDomUtils;
import org.codehaus.plexus.util.StringUtils;
import org.jdom2.Element;

public class JDomDependency
extends Dependency
implements JDomBacked {
    private static final long serialVersionUID = -6973299112773078102L;
    private final Element jdomElement;

    JDomDependency(Element jdomElement) {
        this.jdomElement = jdomElement;
        super.setArtifactId(JDomUtils.getChildElementTextTrim("artifactId", jdomElement));
        super.setClassifier(JDomUtils.getChildElementTextTrim("classifier", jdomElement));
        super.setGroupId(JDomUtils.getChildElementTextTrim("groupId", jdomElement));
        super.setOptional(JDomUtils.getChildElementTextTrim("optional", jdomElement));
        super.setScope(JDomUtils.getChildElementTextTrim("scope", jdomElement));
        super.setSystemPath(JDomUtils.getChildElementTextTrim("systemPath", jdomElement));
        super.setVersion(JDomUtils.getChildElementTextTrim("version", jdomElement));
        String type = JDomUtils.getChildElementTextTrim("type", jdomElement);
        if (type != null) {
            super.setType(type);
        }
    }

    JDomDependency(Element jdomElement, Dependency dependency) {
        List exclusions;
        this.jdomElement = jdomElement;
        this.setArtifactId(dependency.getArtifactId());
        this.setClassifier(dependency.getClassifier());
        this.setGroupId(dependency.getGroupId());
        this.setOptional(dependency.getOptional());
        this.setScope(dependency.getScope());
        this.setSystemPath(dependency.getSystemPath());
        this.setVersion(dependency.getVersion());
        String type = dependency.getType();
        if (!"jar".equals(type)) {
            this.setType(type);
        }
        if (!(exclusions = dependency.getExclusions()).isEmpty()) {
            this.setExclusions(exclusions);
        }
    }

    public void setArtifactId(String artifactId) {
        JDomUtils.rewriteElement("artifactId", artifactId, this.jdomElement);
        super.setArtifactId(StringUtils.trim((String)artifactId));
    }

    public void setClassifier(String classifier) {
        JDomUtils.rewriteElement("classifier", classifier, this.jdomElement);
        super.setClassifier(StringUtils.trim((String)classifier));
    }

    public List<Exclusion> getExclusions() {
        throw new UnsupportedOperationException();
    }

    public void setExclusions(List<Exclusion> exclusions) {
        throw new UnsupportedOperationException();
    }

    public void setGroupId(String groupId) {
        JDomUtils.rewriteElement("groupId", groupId, this.jdomElement);
        super.setGroupId(StringUtils.trim((String)groupId));
    }

    public void setOptional(String optional) {
        JDomUtils.rewriteElement("optional", optional, this.jdomElement);
        super.setOptional(StringUtils.trim((String)optional));
    }

    public void setOptional(boolean optional) {
        this.setOptional(String.valueOf(optional));
    }

    public void setScope(String scope) {
        JDomUtils.rewriteElement("scope", scope, this.jdomElement);
        super.setScope(StringUtils.trim((String)scope));
    }

    public void setSystemPath(String systemPath) {
        JDomUtils.rewriteElement("systemPath", systemPath, this.jdomElement);
        super.setSystemPath(StringUtils.trim((String)systemPath));
    }

    public void setType(String type) {
        JDomUtils.rewriteElement("type", type, this.jdomElement);
        super.setType(StringUtils.defaultString((Object)StringUtils.trim((String)type), (String)"jar"));
    }

    public void setVersion(String version) {
        JDomUtils.rewriteElement("version", version, this.jdomElement);
        super.setVersion(StringUtils.trim((String)version));
    }

    public Dependency clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getJDomElement() {
        return this.jdomElement;
    }
}

