/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.jdom;

import java.util.Collection;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.jdom.JDomBacked;
import org.apache.maven.model.jdom.JDomDependencies;
import org.apache.maven.model.jdom.util.JDomUtils;
import org.jdom2.Element;

public class JDomDependencyManagement
extends DependencyManagement
implements JDomBacked {
    private final Element jdomElement;
    private final JDomBacked parent;

    public JDomDependencyManagement(Element jdomElement, JDomBacked parent) {
        this.jdomElement = jdomElement;
        this.parent = parent;
        Element dependenciesElement = JDomUtils.getChildElement("dependencies", jdomElement);
        if (dependenciesElement == null) {
            dependenciesElement = JDomUtils.newDetachedElement("dependencies", jdomElement);
        }
        super.setDependencies((List)new JDomDependencies(dependenciesElement, this));
    }

    public void setDependencies(List<Dependency> dependencies) {
        if (dependencies == null) {
            JDomUtils.rewriteElement("dependencies", null, this.jdomElement);
        } else {
            JDomDependencies jdomDependencies = (JDomDependencies)this.getDependencies();
            jdomDependencies.clear();
            jdomDependencies.addAll((Collection<? extends Dependency>)dependencies);
        }
    }

    public DependencyManagement clone() {
        return super.clone();
    }

    @Override
    public Element getJDomElement() {
        return this.jdomElement;
    }

    public JDomBacked getParent() {
        return this.parent;
    }
}

