/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.jdom;

import org.apache.maven.model.jdom.JDomBacked;
import org.apache.maven.model.jdom.MavenCoordinate;
import org.apache.maven.model.jdom.util.JDomUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Text;

public class JDomMavenCoordinate
implements JDomBacked,
MavenCoordinate {
    private final Element jdomElement;

    JDomMavenCoordinate(Element jdomElement) {
        this.jdomElement = jdomElement;
    }

    @Override
    public String getArtifactId() {
        return JDomUtils.getChildElementTextTrim("artifactId", this.jdomElement);
    }

    @Override
    public void setArtifactId(String artifactId) {
        JDomUtils.rewriteElement("artifactId", artifactId, this.jdomElement);
    }

    @Override
    public String getGroupId() {
        return JDomUtils.getChildElementTextTrim("groupId", this.jdomElement);
    }

    @Override
    public void setGroupId(String groupId) {
        JDomUtils.rewriteElement("groupId", groupId, this.jdomElement);
    }

    @Override
    public String getVersion() {
        return JDomUtils.getChildElementTextTrim("version", this.jdomElement);
    }

    @Override
    public void setVersion(String version) {
        Element versionElement = JDomUtils.getChildElement("version", this.jdomElement);
        if (versionElement != null) {
            if (version == null) {
                JDomUtils.removeChildElement(this.jdomElement, versionElement);
            } else {
                JDomUtils.rewriteValue(versionElement, version);
            }
        } else if (version != null) {
            versionElement = new Element("version", this.jdomElement.getNamespace());
            versionElement.setText(version);
            int indexArtifactId = this.jdomElement.indexOf((Content)this.jdomElement.getChild("artifactId", this.jdomElement.getNamespace()));
            String indent = JDomUtils.detectIndentation(this.jdomElement);
            if (indent != null) {
                this.jdomElement.addContent(++indexArtifactId, (Content)new Text("\n" + indent));
            }
            this.jdomElement.addContent(++indexArtifactId, (Content)versionElement);
        }
    }

    @Override
    public Element getJDomElement() {
        return this.jdomElement;
    }
}

