/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.jdom;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Scm;
import org.apache.maven.model.jdom.JDomBacked;
import org.apache.maven.model.jdom.JDomMavenCoordinate;
import org.apache.maven.model.jdom.JDomModelBase;
import org.apache.maven.model.jdom.JDomParent;
import org.apache.maven.model.jdom.JDomProfiles;
import org.apache.maven.model.jdom.JDomScm;
import org.apache.maven.model.jdom.MavenCoordinate;
import org.apache.maven.model.jdom.util.JDomUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class JDomModel
extends Model
implements JDomBacked,
MavenCoordinate {
    private final Element jdomElement;
    private final JDomModelBase modelBase;
    private final JDomMavenCoordinate coordinate;

    public JDomModel(Document document) {
        this(document.getRootElement());
    }

    public JDomModel(Element jdomElement) {
        this.jdomElement = jdomElement;
        this.modelBase = new JDomModelBase(jdomElement);
        this.coordinate = new JDomMavenCoordinate(jdomElement);
    }

    @Override
    public String getArtifactId() {
        return this.coordinate.getArtifactId();
    }

    @Override
    public void setArtifactId(String artifactId) {
        this.coordinate.setArtifactId(artifactId);
    }

    public Build getBuild() {
        return this.modelBase.getBuild();
    }

    public void setBuild(Build build) {
        this.modelBase.setBuild((BuildBase)build);
    }

    public CiManagement getCiManagement() {
        throw new UnsupportedOperationException();
    }

    public void setCiManagement(CiManagement ciManagement) {
        throw new UnsupportedOperationException();
    }

    public List<Contributor> getContributors() {
        throw new UnsupportedOperationException();
    }

    public void setContributors(List<Contributor> contributors) {
        throw new UnsupportedOperationException();
    }

    public List<Dependency> getDependencies() {
        return this.modelBase.getDependencies();
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.modelBase.setDependencies(dependencies);
    }

    public DependencyManagement getDependencyManagement() {
        return this.modelBase.getDependencyManagement();
    }

    public void setDependencyManagement(DependencyManagement dependencyManagement) {
        this.modelBase.setDependencyManagement(dependencyManagement);
    }

    public String getDescription() {
        return JDomUtils.getChildElementTextTrim("description", this.jdomElement);
    }

    public void setDescription(String description) {
        JDomUtils.rewriteElement("description", description, this.jdomElement);
    }

    public List<Developer> getDevelopers() {
        throw new UnsupportedOperationException();
    }

    public void setDevelopers(List<Developer> developers) {
        throw new UnsupportedOperationException();
    }

    public DistributionManagement getDistributionManagement() {
        return this.modelBase.getDistributionManagement();
    }

    public void setDistributionManagement(DistributionManagement distributionManagement) {
        this.modelBase.setDistributionManagement(distributionManagement);
    }

    @Override
    public String getGroupId() {
        return this.coordinate.getGroupId();
    }

    @Override
    public void setGroupId(String groupId) {
        String projectGroupId = this.coordinate.getGroupId();
        if (projectGroupId != null) {
            this.coordinate.setGroupId(groupId);
        } else {
            Parent parent = this.getParent();
            if (parent == null || !groupId.equals(parent.getGroupId())) {
                this.coordinate.setGroupId(groupId);
            }
        }
    }

    public String getInceptionYear() {
        return JDomUtils.getChildElementTextTrim("inceptionYear", this.jdomElement);
    }

    public void setInceptionYear(String inceptionYear) {
        JDomUtils.rewriteElement("inceptionYear", inceptionYear, this.jdomElement);
    }

    public IssueManagement getIssueManagement() {
        throw new UnsupportedOperationException();
    }

    public void setIssueManagement(IssueManagement issueManagement) {
        throw new UnsupportedOperationException();
    }

    public List<License> getLicenses() {
        throw new UnsupportedOperationException();
    }

    public void setLicenses(List<License> licenses) {
        throw new UnsupportedOperationException();
    }

    public List<MailingList> getMailingLists() {
        throw new UnsupportedOperationException();
    }

    public void setMailingLists(List<MailingList> mailingLists) {
        throw new UnsupportedOperationException();
    }

    public String getModelVersion() {
        return JDomUtils.getChildElementTextTrim("modelVersion", this.jdomElement);
    }

    public void setModelVersion(String modelVersion) {
        JDomUtils.rewriteElement("modelVersion", modelVersion, this.jdomElement);
    }

    public List<String> getModules() {
        return this.modelBase.getModules();
    }

    public void setModules(List<String> modules) {
        this.modelBase.setModules(modules);
    }

    public String getName() {
        return JDomUtils.getChildElementTextTrim("name", this.jdomElement);
    }

    public void setName(String name) {
        JDomUtils.rewriteElement("name", name, this.jdomElement);
    }

    public Organization getOrganization() {
        throw new UnsupportedOperationException();
    }

    public void setOrganization(Organization organization) {
        throw new UnsupportedOperationException();
    }

    public String getPackaging() {
        return JDomUtils.getChildElementTextTrim("packaging", this.jdomElement);
    }

    public void setPackaging(String packaging) {
        JDomUtils.rewriteElement("packaging", packaging, this.jdomElement);
    }

    public Parent getParent() {
        Element elm = JDomUtils.getChildElement("parent", this.jdomElement);
        if (elm == null) {
            return null;
        }
        return new JDomParent(elm);
    }

    public void setParent(Parent parent) {
        if (parent == null) {
            Parent removedParent = this.getParent();
            JDomUtils.rewriteElement("parent", null, this.jdomElement);
            if (this.getGroupId() == null) {
                this.setGroupId(removedParent.getGroupId());
            }
            if (this.getVersion() == null) {
                this.setVersion(removedParent.getVersion());
            }
        } else {
            boolean containsRelativePath = false;
            Parent jdomParent = this.getParent();
            if (jdomParent == null) {
                Element parentRoot = JDomUtils.insertNewElement("parent", this.jdomElement);
                jdomParent = new JDomParent(parentRoot);
            } else {
                containsRelativePath = jdomParent.getRelativePath() != null;
            }
            jdomParent.setGroupId(parent.getGroupId());
            jdomParent.setArtifactId(parent.getArtifactId());
            jdomParent.setVersion(parent.getVersion());
            String relativePath = parent.getRelativePath();
            if (relativePath != null && !parent.getRelativePath().equals("../pom.xml") || containsRelativePath) {
                jdomParent.setRelativePath(relativePath);
            }
        }
    }

    public List<Repository> getPluginRepositories() {
        return this.modelBase.getPluginRepositories();
    }

    public void setPluginRepositories(List<Repository> pluginRepositories) {
        this.modelBase.setPluginRepositories(pluginRepositories);
    }

    public Prerequisites getPrerequisites() {
        throw new UnsupportedOperationException();
    }

    public void setPrerequisites(Prerequisites prerequisites) {
        throw new UnsupportedOperationException();
    }

    public List<Profile> getProfiles() {
        return new JDomProfiles(this.jdomElement.getChild("profiles", this.jdomElement.getNamespace()), this);
    }

    public void setProfiles(List<Profile> profiles) {
        if (profiles == null) {
            JDomUtils.rewriteElement("profiles", null, this.jdomElement);
        } else {
            new JDomProfiles(JDomUtils.insertNewElement("profiles", this.jdomElement), this).addAll((Collection<? extends Profile>)profiles);
        }
    }

    public Properties getProperties() {
        return this.modelBase.getProperties();
    }

    public void setProperties(Properties properties) {
        this.modelBase.setProperties(properties);
    }

    public Reporting getReporting() {
        return this.modelBase.getReporting();
    }

    public void setReporting(Reporting reporting) {
        this.modelBase.setReporting(reporting);
    }

    public List<Repository> getRepositories() {
        return this.modelBase.getRepositories();
    }

    public void setRepositories(List<Repository> repositories) {
        this.modelBase.setRepositories(repositories);
    }

    public Scm getScm() {
        Element elm = this.jdomElement.getChild("scm", this.jdomElement.getNamespace());
        if (elm == null) {
            return null;
        }
        return new JDomScm(elm);
    }

    public void setScm(Scm scm) {
        if (scm == null) {
            JDomUtils.rewriteElement("scm", null, this.jdomElement);
        } else {
            Scm jdomScm = this.getScm();
            if (jdomScm == null) {
                Element scmRoot = JDomUtils.insertNewElement("scm", this.jdomElement);
                jdomScm = new JDomScm(scmRoot);
            }
            jdomScm.setConnection(scm.getConnection());
            jdomScm.setDeveloperConnection(scm.getDeveloperConnection());
            jdomScm.setTag(scm.getTag());
            jdomScm.setUrl(scm.getUrl());
        }
    }

    public String getUrl() {
        return JDomUtils.getChildElementTextTrim("url", this.jdomElement);
    }

    public void setUrl(String url) {
        JDomUtils.rewriteElement("url", url, this.jdomElement);
    }

    @Override
    public String getVersion() {
        return this.coordinate.getVersion();
    }

    @Override
    public void setVersion(String version) {
        String projectVersion = this.coordinate.getVersion();
        if (projectVersion != null) {
            this.coordinate.setVersion(version);
        } else {
            Parent parent = this.getParent();
            if (parent == null || !version.equals(parent.getVersion())) {
                this.coordinate.setVersion(version);
            }
        }
    }

    public Model clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getJDomElement() {
        return this.jdomElement;
    }
}

