/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.jdom;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.jdom.JDomBacked;
import org.apache.maven.model.jdom.JDomBuild;
import org.apache.maven.model.jdom.JDomDependencies;
import org.apache.maven.model.jdom.JDomDependencyManagement;
import org.apache.maven.model.jdom.JDomModules;
import org.apache.maven.model.jdom.JDomProperties;
import org.apache.maven.model.jdom.JDomReporting;
import org.apache.maven.model.jdom.util.JDomUtils;
import org.jdom2.Element;

public class JDomModelBase
extends ModelBase
implements JDomBacked {
    private final Element jdomElement;

    public JDomModelBase(Element jdomElement) {
        this.jdomElement = jdomElement;
        Element dependenciesElement = JDomUtils.getChildElement("dependencies", jdomElement);
        if (dependenciesElement == null) {
            dependenciesElement = JDomUtils.newDetachedElement("dependencies", jdomElement);
        }
        super.setDependencies((List)new JDomDependencies(dependenciesElement, this));
        Element dependencyManagementElement = JDomUtils.getChildElement("dependencyManagement", jdomElement);
        if (dependencyManagementElement == null) {
            dependencyManagementElement = JDomUtils.newDetachedElement("dependencyManagement", jdomElement);
            JDomUtils.insertNewElement("dependencies", dependencyManagementElement);
        }
        super.setDependencyManagement((DependencyManagement)new JDomDependencyManagement(dependencyManagementElement, this));
    }

    public Build getBuild() {
        Element elm = this.jdomElement.getChild("build", this.jdomElement.getNamespace());
        if (elm == null) {
            return null;
        }
        return new JDomBuild(elm);
    }

    public void setBuild(BuildBase build) {
        if (build == null) {
            JDomUtils.rewriteElement("build", null, this.jdomElement);
        } else {
            Element jdomBuild = JDomUtils.insertNewElement("build", this.jdomElement);
            JDomModelBase.insertPluginManagement(jdomBuild, build.getPluginManagement());
        }
    }

    public DistributionManagement getDistributionManagement() {
        throw new UnsupportedOperationException();
    }

    public void setDistributionManagement(DistributionManagement distributionManagement) {
        throw new UnsupportedOperationException();
    }

    public void setDependencies(List<Dependency> dependencies) {
        if (dependencies == null) {
            JDomUtils.rewriteElement("dependencies", null, this.jdomElement);
        } else {
            new JDomDependencies(JDomUtils.insertNewElement("dependencies", this.jdomElement), this).addAll((Collection<? extends Dependency>)dependencies);
        }
    }

    public void setDependencyManagement(DependencyManagement dependencyManagement) {
        if (dependencyManagement == null) {
            JDomUtils.rewriteElement("dependencyManagement", null, this.jdomElement);
        } else {
            DependencyManagement jdomDependencyManagement = this.getDependencyManagement();
            if (jdomDependencyManagement == null) {
                Element dependencyManagementRoot = JDomUtils.insertNewElement("dependencyManagement", this.jdomElement);
                jdomDependencyManagement = new JDomDependencyManagement(dependencyManagementRoot, this);
            }
            jdomDependencyManagement.setDependencies(dependencyManagement.getDependencies());
        }
    }

    public List<String> getModules() {
        Element modulesElement = JDomUtils.getChildElement("modules", this.jdomElement);
        if (modulesElement == null) {
            return Collections.emptyList();
        }
        return new JDomModules(modulesElement);
    }

    public void setModules(List<String> modules) {
        if (modules == null) {
            JDomUtils.rewriteElement("modules", null, this.jdomElement);
        } else {
            JDomModules jDomModules = this.getModules();
            if (jDomModules instanceof JDomModules) {
                jDomModules.clear();
            } else {
                jDomModules = new JDomModules(JDomUtils.insertNewElement("modules", this.jdomElement));
            }
            jDomModules.addAll(modules);
        }
    }

    public List<Repository> getPluginRepositories() {
        throw new UnsupportedOperationException();
    }

    public void setPluginRepositories(List<Repository> pluginRepositories) {
        throw new UnsupportedOperationException();
    }

    public Properties getProperties() {
        Element properties = this.jdomElement.getChild("properties", this.jdomElement.getNamespace());
        if (properties == null) {
            return null;
        }
        return new JDomProperties(properties);
    }

    public void setProperties(Properties properties) {
        if (properties == null) {
            JDomUtils.rewriteElement("properties", null, this.jdomElement);
        } else {
            Properties jDomProperties = this.getProperties();
            if (jDomProperties != null) {
                jDomProperties.clear();
            } else {
                jDomProperties = new JDomProperties(JDomUtils.insertNewElement("properties", this.jdomElement));
            }
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                jDomProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public Reporting getReporting() {
        Element reporting = this.jdomElement.getChild("reporting", this.jdomElement.getNamespace());
        if (reporting == null) {
            return null;
        }
        return new JDomReporting(reporting);
    }

    public void setReporting(Reporting reporting) {
        throw new UnsupportedOperationException();
    }

    public List<Repository> getRepositories() {
        throw new UnsupportedOperationException();
    }

    public void setRepositories(List<Repository> repositories) {
        throw new UnsupportedOperationException();
    }

    public ModelBase clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getJDomElement() {
        return this.jdomElement;
    }

    private static void insertPluginManagement(Element jdomParent, PluginManagement pluginManagement) {
        if (pluginManagement != null) {
            Element jdomPlugins = JDomUtils.insertNewNestedElements(jdomParent, "pluginManagement", "plugins");
            JDomModelBase.insertPlugins(jdomPlugins, pluginManagement.getPlugins());
        }
    }

    private static void insertPlugins(Element jdomPlugins, List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            Element jdomPlugin = JDomUtils.insertNewElement("plugin", jdomPlugins);
            JDomModelBase.insertGAV(jdomPlugin, plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion());
        }
    }

    private static void insertGAV(Element jdomParent, String groupId, String artifactId, String version) {
        JDomUtils.insertContentElement(jdomParent, "groupId", groupId);
        JDomUtils.insertContentElement(jdomParent, "artifactId", artifactId);
        JDomUtils.insertContentElement(jdomParent, "version", version);
    }
}

