/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.jdom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.apache.maven.model.jdom.JDomBacked;
import org.apache.maven.model.jdom.util.JDomUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Text;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;

public class JDomModules
extends ArrayList<String>
implements JDomBacked {
    private final Element jdomElement;

    public JDomModules(Element jdomElement) {
        super(JDomModules.transformToElementTextList(JDomModules.getModuleElements(jdomElement)));
        this.jdomElement = jdomElement;
    }

    private static List<Element> getModuleElements(Element modules) {
        return modules.getContent((Filter)new ElementFilter(modules.getNamespace()));
    }

    private static List<String> transformToElementTextList(List<Element> elements) {
        ArrayList<String> elementTextList = new ArrayList<String>(elements.size());
        for (Element element : elements) {
            elementTextList.add(element.getTextTrim());
        }
        return elementTextList;
    }

    @Override
    public boolean add(String module) {
        Element newModule = new Element("module", this.jdomElement.getNamespace());
        newModule.setText(module);
        this.jdomElement.addContent(this.jdomElement.getContentSize() - 1, Arrays.asList(new Text("\n" + JDomUtils.detectIndentation(this.jdomElement)), newModule));
        return super.add(module);
    }

    @Override
    public boolean remove(final Object module) {
        List removeElements = this.jdomElement.getContent((Filter)new ElementFilter(){

            public Element filter(Object content) {
                Element element = super.filter(content);
                return element == null || !module.equals(element.getTextTrim()) ? null : element;
            }
        });
        for (Element removeElement : removeElements) {
            JDomUtils.removeChildAndItsCommentFromContent(this.jdomElement, (Content)removeElement);
        }
        return super.remove(module);
    }

    @Override
    public boolean addAll(Collection<? extends String> modules) {
        boolean added = false;
        for (String string : modules) {
            added |= this.add(string);
        }
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> modules) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> modules) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> modules) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        while (this.size() > 0) {
            this.remove(0);
        }
    }

    @Override
    public String set(int index, String module) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, String module) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String remove(int index) {
        String module = (String)this.get(index);
        this.remove(module);
        return module;
    }

    @Override
    public int lastIndexOf(Object module) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<String> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<String> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getJDomElement() {
        return this.jdomElement;
    }
}

