/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.jdom;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.jdom.JDomBacked;
import org.apache.maven.model.jdom.JDomDependencies;
import org.apache.maven.model.jdom.JDomExecutions;
import org.apache.maven.model.jdom.JDomMavenCoordinate;
import org.apache.maven.model.jdom.MavenCoordinate;
import org.apache.maven.model.jdom.util.JDomConfigurationContainerHelper;
import org.apache.maven.model.jdom.util.JDomUtils;
import org.jdom2.Element;

public class JDomPlugin
extends Plugin
implements JDomBacked,
MavenCoordinate {
    private final Element jdomElement;
    private final MavenCoordinate coordinate;

    public JDomPlugin(Element jdomElement) {
        this.jdomElement = jdomElement;
        this.coordinate = new JDomMavenCoordinate(jdomElement);
    }

    @Override
    public String getArtifactId() {
        return this.coordinate.getArtifactId();
    }

    @Override
    public void setArtifactId(String artifactId) {
        this.coordinate.setArtifactId(artifactId);
    }

    public Object getConfiguration() {
        return JDomConfigurationContainerHelper.getConfiguration(this.jdomElement);
    }

    public void setConfiguration(Object configuration) {
        JDomConfigurationContainerHelper.setConfiguration(this.jdomElement, configuration);
    }

    public List<Dependency> getDependencies() {
        Element dependenciesElm = this.jdomElement.getChild("dependencies", this.jdomElement.getNamespace());
        return new JDomDependencies(dependenciesElm, this);
    }

    public void setDependencies(List<Dependency> dependencies) {
        if (dependencies == null) {
            JDomUtils.rewriteElement("dependencies", null, this.jdomElement);
        } else {
            new JDomDependencies(JDomUtils.insertNewElement("dependencies", this.jdomElement), this).addAll((Collection<? extends Dependency>)dependencies);
        }
    }

    public List<PluginExecution> getExecutions() {
        Element executionsElm = this.jdomElement.getChild("executions", this.jdomElement.getNamespace());
        return executionsElm == null ? Collections.emptyList() : new JDomExecutions(executionsElm, this);
    }

    public void setExecutions(List<PluginExecution> executions) {
        if (executions == null) {
            JDomUtils.rewriteElement("executions", null, this.jdomElement);
        } else {
            Element executionsElement = JDomUtils.insertNewElement("executions", this.jdomElement);
            for (PluginExecution execution : executions) {
                Element executionElement = JDomUtils.insertNewElement("execution", executionsElement);
                if (execution.getId() != null && !"default".equals(execution.getId())) {
                    Element executionIdElement = JDomUtils.insertNewElement("id", executionElement);
                    executionIdElement.setText(execution.getId());
                }
                if (execution.getPhase() != null) {
                    Element executionPhaseElement = JDomUtils.insertNewElement("phase", executionElement);
                    executionPhaseElement.setText(execution.getPhase());
                }
                if (execution.getGoals() == null) continue;
                Element executionGoalsElement = JDomUtils.insertNewElement("goals", executionElement);
                for (String goal : execution.getGoals()) {
                    Element executionGoalElement = JDomUtils.insertNewElement("goal", executionGoalsElement);
                    executionGoalElement.setText(goal);
                }
            }
        }
    }

    public String getExtensions() {
        return JDomUtils.getChildElementTextTrim("extensions", this.jdomElement);
    }

    public void setExtensions(String extensions) {
        JDomUtils.rewriteElement("extensions", extensions, this.jdomElement);
    }

    public boolean isExtensions() {
        return Boolean.parseBoolean(this.getExtensions());
    }

    public void setExtensions(boolean extensions) {
        this.setExtensions(Boolean.toString(extensions));
    }

    public Object getGoals() {
        throw new UnsupportedOperationException();
    }

    public void setGoals(Object goals) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getGroupId() {
        return this.coordinate.getGroupId();
    }

    @Override
    public void setGroupId(String groupId) {
        this.coordinate.setGroupId(groupId);
    }

    public String getInherited() {
        return JDomUtils.getChildElementTextTrim("inherited", this.jdomElement);
    }

    public void setInherited(String inherited) {
        JDomUtils.rewriteElement("inherited", inherited, this.jdomElement);
    }

    public boolean isInherited() {
        return Boolean.parseBoolean(this.getInherited());
    }

    public void setInherited(boolean inherited) {
        this.setInherited(Boolean.toString(inherited));
    }

    @Override
    public String getVersion() {
        return this.coordinate.getVersion();
    }

    @Override
    public void setVersion(String version) {
        this.coordinate.setVersion(version);
    }

    public void flushExecutionMap() {
        throw new UnsupportedOperationException();
    }

    public Map<String, PluginExecution> getExecutionsAsMap() {
        throw new UnsupportedOperationException();
    }

    public String getKey() {
        return JDomPlugin.constructKey((String)this.getGroupId(), (String)this.getArtifactId());
    }

    public Plugin clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getJDomElement() {
        return this.jdomElement;
    }
}

