/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.jdom;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.jdom.JDomBacked;
import org.apache.maven.model.jdom.JDomPlugins;
import org.apache.maven.model.jdom.util.JDomUtils;
import org.jdom2.Element;

public class JDomPluginManagement
extends PluginManagement
implements JDomBacked {
    private final Element jdomElement;

    public JDomPluginManagement(Element jdomElement) {
        this.jdomElement = jdomElement;
    }

    public List<Plugin> getPlugins() {
        Element pluginsElm = this.jdomElement.getChild("plugins", this.jdomElement.getNamespace());
        if (pluginsElm == null) {
            return Collections.emptyList();
        }
        return new JDomPlugins(pluginsElm);
    }

    public void setPlugins(List<Plugin> plugins) {
        if (plugins == null) {
            JDomUtils.rewriteElement("plugins", null, this.jdomElement);
        } else {
            new JDomPlugins(JDomUtils.insertNewElement("plugins", this.jdomElement)).addAll((Collection<? extends Plugin>)plugins);
        }
    }

    public void flushPluginMap() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Plugin> getPluginsAsMap() {
        throw new UnsupportedOperationException();
    }

    public PluginManagement clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getJDomElement() {
        return this.jdomElement;
    }
}

