/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.jdom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.jdom.JDomBacked;
import org.apache.maven.model.jdom.JDomPlugin;
import org.apache.maven.model.jdom.util.JDomUtils;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;

public class JDomPlugins
extends ArrayList<Plugin>
implements JDomBacked {
    private final Element jdomElement;

    public JDomPlugins(Element jdomElement) {
        super(JDomPlugins.transformToJDomPluginList(JDomPlugins.getPluginElements(jdomElement)));
        this.jdomElement = jdomElement;
    }

    private static List<Element> getPluginElements(Element plugins) {
        return plugins.getContent((Filter)new ElementFilter("plugin", plugins.getNamespace()));
    }

    private static List<JDomPlugin> transformToJDomPluginList(List<Element> pluginElements) {
        ArrayList<JDomPlugin> jDomPluginList = new ArrayList<JDomPlugin>(pluginElements.size());
        for (Element pluginElement : pluginElements) {
            jDomPluginList.add(new JDomPlugin(pluginElement));
        }
        return jDomPluginList;
    }

    @Override
    public void add(int index, Plugin plugin) {
        if (plugin instanceof JDomPlugin) {
            if (index == -1) {
                JDomUtils.addElement(((JDomPlugin)plugin).getJDomElement().clone(), this.jdomElement);
            } else {
                JDomUtils.addElement(((JDomPlugin)plugin).getJDomElement().clone(), this.jdomElement, index);
            }
        } else {
            List executions;
            Element newElement = index == -1 ? JDomUtils.insertNewElement("plugin", this.jdomElement) : JDomUtils.insertNewElement("plugin", this.jdomElement, index);
            JDomPlugin jDomPlugin = new JDomPlugin(newElement);
            jDomPlugin.setGroupId(plugin.getGroupId());
            jDomPlugin.setArtifactId(plugin.getArtifactId());
            jDomPlugin.setVersion(plugin.getVersion());
            List dependencies = plugin.getDependencies();
            if (!dependencies.isEmpty()) {
                jDomPlugin.setDependencies(dependencies);
            }
            if (plugin.isExtensions()) {
                jDomPlugin.setExtensions(true);
            }
            if (!(executions = plugin.getExecutions()).isEmpty()) {
                jDomPlugin.setExecutions(executions);
            }
            if (!plugin.isInherited()) {
                jDomPlugin.setInherited(false);
            }
        }
        if (index == -1) {
            super.add(plugin);
        } else {
            super.add(index, plugin);
        }
    }

    @Override
    public boolean remove(Object plugin) {
        Plugin removePlugin = (Plugin)plugin;
        for (Plugin candidate : this) {
            if (!Objects.equals(candidate.getGroupId(), removePlugin.getGroupId()) || !Objects.equals(candidate.getArtifactId(), removePlugin.getArtifactId())) continue;
            JDomUtils.removeChildElement(this.jdomElement, ((JDomPlugin)candidate).getJDomElement());
            return super.remove(removePlugin);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends Plugin> plugins) {
        boolean added = false;
        for (Plugin plugin : plugins) {
            added |= this.add(plugin);
        }
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Plugin> plugins) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> plugins) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> plugins) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        while (this.size() > 0) {
            this.remove(0);
        }
    }

    @Override
    public Plugin set(int index, Plugin plugin) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Plugin plugin) {
        this.add(-1, plugin);
        return true;
    }

    @Override
    public Plugin remove(int index) {
        Plugin plugin = (Plugin)this.get(index);
        this.remove(plugin);
        return plugin;
    }

    @Override
    public int lastIndexOf(Object plugin) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Plugin> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Plugin> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Plugin> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getJDomElement() {
        return this.jdomElement;
    }
}

