/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.jdom;

import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.jdom.JDomActivation;
import org.apache.maven.model.jdom.JDomBacked;
import org.apache.maven.model.jdom.JDomModelBase;
import org.apache.maven.model.jdom.util.JDomUtils;
import org.jdom2.Element;

public class JDomProfile
extends Profile
implements JDomBacked {
    private final Element jdomElement;
    private final JDomModelBase modelBase;

    public JDomProfile(Element jdomElement) {
        this.jdomElement = jdomElement;
        this.modelBase = new JDomModelBase(jdomElement);
    }

    public Activation getActivation() {
        Element elm = this.jdomElement.getChild("activation", this.jdomElement.getNamespace());
        if (elm == null) {
            return null;
        }
        return new JDomActivation(elm);
    }

    public void setActivation(Activation activation) {
        if (activation == null) {
            JDomUtils.rewriteElement("activation", null, this.jdomElement);
        } else {
            ActivationProperty property;
            ActivationOS os;
            String jdk;
            Activation jdomActivation = this.getActivation();
            if (jdomActivation == null) {
                Element activationRoot = JDomUtils.insertNewElement("activation", this.jdomElement);
                jdomActivation = new JDomActivation(activationRoot);
            }
            jdomActivation.setActiveByDefault(activation.isActiveByDefault());
            ActivationFile file = activation.getFile();
            if (file != null) {
                jdomActivation.setFile(file);
            }
            if ((jdk = activation.getJdk()) != null) {
                jdomActivation.setJdk(jdk);
            }
            if ((os = activation.getOs()) != null) {
                jdomActivation.setOs(os);
            }
            if ((property = activation.getProperty()) != null) {
                jdomActivation.setProperty(property);
            }
        }
        super.setActivation(activation);
    }

    public BuildBase getBuild() {
        return this.modelBase.getBuild();
    }

    public void setBuild(BuildBase build) {
        this.modelBase.setBuild(build);
    }

    public List<Dependency> getDependencies() {
        return this.modelBase.getDependencies();
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.modelBase.setDependencies(dependencies);
    }

    public DependencyManagement getDependencyManagement() {
        return this.modelBase.getDependencyManagement();
    }

    public void setDependencyManagement(DependencyManagement dependencyManagement) {
        this.modelBase.setDependencyManagement(dependencyManagement);
    }

    public DistributionManagement getDistributionManagement() {
        return this.modelBase.getDistributionManagement();
    }

    public void setDistributionManagement(DistributionManagement distributionManagement) {
        this.modelBase.setDistributionManagement(distributionManagement);
    }

    public String getId() {
        return JDomUtils.getChildElementTextTrim("id", this.jdomElement);
    }

    public void setId(String id) {
        JDomUtils.rewriteElement("id", id, this.jdomElement);
    }

    public List<String> getModules() {
        return this.modelBase.getModules();
    }

    public void setModules(List<String> modules) {
        this.modelBase.setModules(modules);
    }

    public List<Repository> getPluginRepositories() {
        return this.modelBase.getPluginRepositories();
    }

    public void setPluginRepositories(List<Repository> pluginRepositories) {
        this.modelBase.setPluginRepositories(pluginRepositories);
    }

    public Properties getProperties() {
        return this.modelBase.getProperties();
    }

    public void setProperties(Properties properties) {
        this.modelBase.setProperties(properties);
    }

    public Reporting getReporting() {
        return this.modelBase.getReporting();
    }

    public void setReporting(Reporting reporting) {
        this.modelBase.setReporting(reporting);
    }

    public List<Repository> getRepositories() {
        return this.modelBase.getRepositories();
    }

    public void setRepositories(List<Repository> repositories) {
        this.modelBase.setRepositories(repositories);
    }

    public Profile clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getJDomElement() {
        return this.jdomElement;
    }
}

