/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.jdom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.apache.maven.model.Activation;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.jdom.JDomBacked;
import org.apache.maven.model.jdom.JDomModel;
import org.apache.maven.model.jdom.JDomProfile;
import org.apache.maven.model.jdom.util.JDomUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;

public class JDomProfiles
extends ArrayList<Profile>
implements JDomBacked {
    private Element jdomElement;
    private JDomModel parent;

    public JDomProfiles(Element jdomElement, JDomModel parent) {
        super(JDomProfiles.transformToJDomProfileList(JDomProfiles.getProfileElements(jdomElement)));
        this.jdomElement = jdomElement;
        this.parent = parent;
    }

    private static List<Element> getProfileElements(Element profiles) {
        if (profiles == null) {
            return Collections.emptyList();
        }
        return profiles.getContent((Filter)new ElementFilter("profile", profiles.getNamespace()));
    }

    private static List<JDomProfile> transformToJDomProfileList(List<Element> profileElements) {
        ArrayList<JDomProfile> jDomProfileList = new ArrayList<JDomProfile>(profileElements.size());
        for (Element profileElement : profileElements) {
            jDomProfileList.add(new JDomProfile(profileElement));
        }
        return jDomProfileList;
    }

    @Override
    public boolean add(Profile profile) {
        if (this.jdomElement == null) {
            this.jdomElement = JDomUtils.insertNewElement("profiles", this.parent.getJDomElement());
        }
        if (profile instanceof JDomProfile) {
            JDomUtils.addElement(((JDomProfile)profile).getJDomElement().clone(), this.jdomElement);
        } else {
            Reporting reporting;
            Properties properties;
            List repositories;
            List pluginRepositories;
            List modules;
            DistributionManagement distributionManagement;
            DependencyManagement dependencyManagement;
            List dependencies;
            BuildBase build;
            Element newElement = JDomUtils.insertNewElement("profile", this.jdomElement);
            JDomProfile jDomProfile = new JDomProfile(newElement);
            jDomProfile.setId(profile.getId());
            Activation activation = profile.getActivation();
            if (activation != null) {
                jDomProfile.setActivation(activation);
            }
            if ((build = profile.getBuild()) != null) {
                jDomProfile.setBuild(build);
            }
            if (!(dependencies = profile.getDependencies()).isEmpty()) {
                jDomProfile.setDependencies(dependencies);
            }
            if ((dependencyManagement = profile.getDependencyManagement()) != null) {
                jDomProfile.setDependencyManagement(dependencyManagement);
            }
            if ((distributionManagement = profile.getDistributionManagement()) != null) {
                jDomProfile.setDistributionManagement(distributionManagement);
            }
            if (!(modules = profile.getModules()).isEmpty()) {
                jDomProfile.setModules(modules);
            }
            if (!(pluginRepositories = profile.getPluginRepositories()).isEmpty()) {
                jDomProfile.setPluginRepositories(pluginRepositories);
            }
            if (!(repositories = profile.getRepositories()).isEmpty()) {
                jDomProfile.setRepositories(repositories);
            }
            if (!(properties = profile.getProperties()).isEmpty()) {
                jDomProfile.setProperties(properties);
            }
            if ((reporting = profile.getReporting()) != null) {
                jDomProfile.setReporting(reporting);
            }
        }
        return super.add(profile);
    }

    @Override
    public boolean remove(Object profile) {
        Profile removeProfile = (Profile)profile;
        for (Profile candidate : this) {
            if (!candidate.getId().equals(removeProfile.getId())) continue;
            JDomUtils.removeChildAndItsCommentFromContent(this.jdomElement, (Content)((JDomProfile)candidate).getJDomElement());
            boolean remove = super.remove(candidate);
            if (super.isEmpty()) {
                JDomUtils.removeChildAndItsCommentFromContent(this.parent.getJDomElement(), (Content)this.jdomElement);
            }
            return remove;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends Profile> profiles) {
        boolean added = false;
        for (Profile profile : profiles) {
            added |= this.add(profile);
        }
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Profile> profiles) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> profiles) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> profiles) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        while (this.size() > 0) {
            this.remove(0);
        }
    }

    @Override
    public Profile set(int index, Profile profile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, Profile profile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Profile remove(int index) {
        Profile profile = (Profile)this.get(index);
        this.remove(profile);
        return profile;
    }

    @Override
    public int lastIndexOf(Object profile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Profile> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Profile> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Profile> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getJDomElement() {
        return this.jdomElement;
    }
}

