/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.jdom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.jdom.JDomBacked;
import org.apache.maven.model.jdom.util.JDomUtils;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;

public class JDomProperties
extends Properties
implements JDomBacked {
    private final Element jdomElement;

    public JDomProperties(Element jdomElement) {
        this.jdomElement = jdomElement;
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        JDomPropertiesSet entrySet = new JDomPropertiesSet();
        for (Element property : this.jdomElement.getContent((Filter)new ElementFilter(this.jdomElement.getNamespace()))) {
            entrySet.addProperty(new JDomProperty(property));
        }
        return entrySet;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        String previousValue = JDomUtils.getChildElementTextTrim((String)key, this.jdomElement);
        JDomUtils.rewriteElement((String)key, (String)value, this.jdomElement);
        return previousValue;
    }

    @Override
    public synchronized Object remove(Object key) {
        String previousValue = JDomUtils.getChildElementTextTrim((String)key, this.jdomElement);
        JDomUtils.rewriteElement((String)key, null, this.jdomElement);
        return previousValue;
    }

    @Override
    public synchronized void load(Reader reader) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save(OutputStream out, String comments) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void store(Writer writer, String comments) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void loadFromXML(InputStream in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeToXML(OutputStream os, String comment) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(Object key) {
        return key instanceof String ? this.getProperty((String)key) : null;
    }

    @Override
    public int size() {
        return this.jdomElement.getChildren().size();
    }

    @Override
    public String toString() {
        String kvs = this.jdomElement.getChildren().stream().map(j -> j.getName() + "=" + j.getTextTrim()).collect(Collectors.joining("\n"));
        return "JDomProperties{\n" + kvs + "\n}";
    }

    @Override
    public String getProperty(String key) {
        Element property = this.jdomElement.getChild(key, this.jdomElement.getNamespace());
        if (property == null) {
            return null;
        }
        return property.getTextTrim();
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Enumeration<?> propertyNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> stringPropertyNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void list(PrintStream out) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void list(PrintWriter out) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getJDomElement() {
        return this.jdomElement;
    }

    private static class JDomProperty
    implements JDomBacked,
    Map.Entry<Object, Object> {
        private final Element jdElement;

        private JDomProperty(Element jdElement) {
            this.jdElement = jdElement;
        }

        @Override
        public Object getKey() {
            return this.jdElement.getName();
        }

        @Override
        public Object getValue() {
            return this.jdElement.getTextTrim();
        }

        @Override
        public Object setValue(Object value) {
            String previousValue = this.jdElement.getTextTrim();
            this.jdElement.setText((String)value);
            return previousValue;
        }

        protected Object clone() throws CloneNotSupportedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Element getJDomElement() {
            return this.jdElement;
        }
    }

    private class JDomPropertiesSet
    extends HashSet<Map.Entry<Object, Object>> {
        private JDomPropertiesSet() {
        }

        private void addProperty(JDomProperty jDomProperty) {
            super.add(jDomProperty);
        }

        @Override
        public boolean add(Map.Entry<Object, Object> objectObjectEntry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<Object, Object>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

