/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.jdom.etl;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.apache.maven.model.jdom.JDomModel;
import org.apache.maven.model.jdom.etl.ModelETL;
import org.apache.maven.model.jdom.etl.ModelETLRequest;
import org.apache.maven.model.jdom.util.JDomCleanupHelper;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.jdom2.CDATA;
import org.jdom2.Comment;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.filter.ContentFilter;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.util.IteratorIterable;

public class JDomModelETL
implements ModelETL {
    private ModelETLRequest modelETLRequest = new ModelETLRequest();
    private JDomModel model;
    private Document document;
    private String intro = null;
    private String outtro = null;

    @Override
    public void extract(File pomFile) throws IOException, JDOMException {
        if (this.model != null) {
            throw new IllegalStateException("A model has already been extracted");
        }
        String content = JDomModelETL.readXmlFile(pomFile, this.modelETLRequest.getLineSeparator());
        content = content.replaceAll("<([^!][^>]*?)\\s{2,}([^>]*?)>", "<$1 $2>");
        content = content.replaceAll("(\\s{2,})/>", "$1 />");
        SAXBuilder builder = new SAXBuilder();
        this.document = builder.build((Reader)new StringReader(content));
        this.normaliseLineEndings(this.document);
        StringWriter w = new StringWriter();
        JDomModelETL.printDocumentToWriter(this.document, w, this.modelETLRequest.getLineSeparator());
        int index = content.indexOf(w.toString());
        if (index >= 0) {
            this.intro = content.substring(0, index);
            this.outtro = content.substring(index + w.toString().length());
        } else {
            String SPACE = "\\s++";
            String XML = "<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>";
            String INTSUB = "\\[(?:(?:[^\"'\\]]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+\\]";
            String DOCTYPE = "<!DOCTYPE(?:(?:[^\"'\\[>]++)|(?:\"[^\"]*+\")|(?:'[^']*+')|(?:\\[(?:(?:[^\"'\\]]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+\\]))*+>";
            String PI = "<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>";
            String COMMENT = "<!--(?:[^-]|(?:-[^-]))*+-->";
            String INTRO = "(?:(?:\\s++)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>)|(?:<!DOCTYPE(?:(?:[^\"'\\[>]++)|(?:\"[^\"]*+\")|(?:'[^']*+')|(?:\\[(?:(?:[^\"'\\]]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+\\]))*+>)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*";
            String OUTRO = "(?:(?:\\s++)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*";
            String POM = "(?s)((?:(?:\\s++)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>)|(?:<!DOCTYPE(?:(?:[^\"'\\[>]++)|(?:\"[^\"]*+\")|(?:'[^']*+')|(?:\\[(?:(?:[^\"'\\]]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+\\]))*+>)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*)(.*?)((?:(?:\\s++)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*)";
            Matcher matcher = Pattern.compile("(?s)((?:(?:\\s++)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>)|(?:<!DOCTYPE(?:(?:[^\"'\\[>]++)|(?:\"[^\"]*+\")|(?:'[^']*+')|(?:\\[(?:(?:[^\"'\\]]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+\\]))*+>)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*)(.*?)((?:(?:\\s++)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*)").matcher(content);
            if (matcher.matches()) {
                this.intro = matcher.group(1);
                this.outtro = matcher.group(matcher.groupCount());
            }
        }
        this.model = new JDomModel(this.document);
        this.model.setPomFile(pomFile);
    }

    @Override
    public void transform() {
    }

    @Override
    public void load(File targetFile) throws IOException {
        if (this.model == null) {
            throw new IllegalStateException("A model must be extracted first");
        }
        this.writePom(targetFile);
    }

    @Override
    public Model getModel() {
        if (this.model == null) {
            throw new IllegalStateException("A model must be extracted first");
        }
        return this.model;
    }

    private void normaliseLineEndings(Document document) {
        Comment c;
        IteratorIterable i = document.getDescendants((Filter)new ContentFilter(8));
        while (i.hasNext()) {
            c = (Comment)i.next();
            c.setText(JDomModelETL.normalizeLineEndings(c.getText(), this.modelETLRequest.getLineSeparator()));
        }
        i = document.getDescendants((Filter)new ContentFilter(2));
        while (i.hasNext()) {
            c = (CDATA)i.next();
            c.setText(JDomModelETL.normalizeLineEndings(c.getText(), this.modelETLRequest.getLineSeparator()));
        }
    }

    public void cleanup() {
        this.cleanup(Arrays.asList("modules", "properties", "dependencies", "dependencyManagement"), Arrays.asList("project"));
    }

    public void cleanup(List<String> cleanUpEmptyElements, List<String> profilesParents) {
        Element rootElement = this.document.getRootElement();
        for (String cleanUpEmptyElement : cleanUpEmptyElements) {
            JDomCleanupHelper.cleanupEmptyElements(rootElement, cleanUpEmptyElement);
        }
        JDomCleanupHelper.cleanupEmptyProfiles(rootElement, profilesParents);
    }

    public void squashMultilines() {
        Element rootElement = this.document.getRootElement();
        JDomCleanupHelper.squashMultilines(rootElement);
    }

    private void writePom(File pomFile) throws IOException {
        Element rootElement = this.document.getRootElement();
        if (this.modelETLRequest.isAddSchema()) {
            String modelVersion = this.model.getModelVersion();
            Namespace pomNamespace = Namespace.getNamespace((String)"", (String)("http://maven.apache.org/POM/" + modelVersion));
            rootElement.setNamespace(pomNamespace);
            Namespace xsiNamespace = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
            rootElement.addNamespaceDeclaration(xsiNamespace);
            if (rootElement.getAttribute("schemaLocation", xsiNamespace) == null) {
                rootElement.setAttribute("schemaLocation", "http://maven.apache.org/POM/" + modelVersion + " http://maven.apache.org/maven-v" + modelVersion.replace('.', '_') + ".xsd", xsiNamespace);
            }
            ElementFilter elementFilter = new ElementFilter(Namespace.getNamespace((String)""));
            IteratorIterable i = rootElement.getDescendants((Filter)elementFilter);
            while (i.hasNext()) {
                Element e = (Element)i.next();
                e.setNamespace(pomNamespace);
            }
        }
        try (XmlStreamWriter writer = WriterFactory.newXmlWriter((File)pomFile);){
            if (this.intro != null) {
                writer.write(this.intro);
            }
            JDomModelETL.printDocumentToWriter(this.document, (Writer)writer, this.modelETLRequest.getLineSeparator());
            if (this.outtro != null) {
                writer.write(this.outtro);
            }
        }
    }

    private static void printDocumentToWriter(Document document, Writer writer, String lineSeparator) throws IOException {
        Format format = Format.getRawFormat();
        format.setLineSeparator(lineSeparator);
        XMLOutputter out = new XMLOutputter(format);
        out.output(document.getRootElement(), writer);
    }

    private static String readXmlFile(File file, String ls) throws IOException {
        try (XmlStreamReader reader = ReaderFactory.newXmlReader((File)file);){
            String string = JDomModelETL.normalizeLineEndings(IOUtil.toString((Reader)reader), ls);
            return string;
        }
    }

    private static String normalizeLineEndings(String text, String separator) {
        String norm = text;
        if (text != null) {
            norm = text.replaceAll("(\r\n)|(\n)|(\r)", separator);
        }
        return norm;
    }

    void setModelETLRequest(ModelETLRequest modelETLRequest) {
        this.modelETLRequest = modelETLRequest;
    }
}

