/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.jdom.util;

import java.util.Arrays;
import org.apache.maven.model.jdom.JDomConfiguration;
import org.apache.maven.model.jdom.util.JDomUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Text;

public class JDomConfigurationContainerHelper {
    public static JDomConfiguration getConfiguration(Element jdomElement) {
        Element elm = JDomUtils.getChildElement("configuration", jdomElement);
        if (elm == null) {
            return null;
        }
        return new JDomConfiguration(elm);
    }

    public static void setConfiguration(Element jdomElement, Object configuration) {
        if (configuration == null) {
            JDomUtils.rewriteElement("configuration", null, jdomElement);
        } else if (configuration instanceof JDomConfiguration) {
            Element newJDomConfigurationElement = ((JDomConfiguration)configuration).getJDomElement().clone();
            JDomConfiguration oldJDomConfiguration = JDomConfigurationContainerHelper.getConfiguration(jdomElement);
            if (oldJDomConfiguration == null) {
                jdomElement.addContent(jdomElement.getContentSize() - 1, Arrays.asList(new Text("\n" + JDomUtils.detectIndentation(jdomElement)), newJDomConfigurationElement));
            } else {
                int replaceIndex = jdomElement.indexOf((Content)oldJDomConfiguration.getJDomElement());
                jdomElement.removeContent(replaceIndex);
                jdomElement.addContent(replaceIndex, (Content)newJDomConfigurationElement);
            }
            JDomUtils.resetIndentations(jdomElement, JDomUtils.detectIndentation(jdomElement));
            JDomUtils.resetIndentations(newJDomConfigurationElement, JDomUtils.detectIndentation(jdomElement) + "  ");
        }
    }
}

