/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.jdom.util;

import org.codehaus.plexus.util.StringUtils;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JDomContentHelper {
    private static final Logger LOG = LoggerFactory.getLogger(JDomContentHelper.class);

    JDomContentHelper() {
    }

    static String contentAsString(Content content) {
        if (content instanceof Element) {
            return JDomContentHelper.elementToString((Element)content);
        }
        if (content instanceof Text) {
            return JDomContentHelper.textToString((Text)content);
        }
        if (null != content) {
            return content.getCType() + " => " + content.getValue().trim();
        }
        return "content is null";
    }

    private static String elementToString(Element element) {
        return element.getCType() + " => <" + element.getName() + "> : " + element.getValue().trim().replaceAll("\n", "\\\\n");
    }

    private static String textToString(Text text) {
        String value = text.getValue().replaceAll("\n", "\\\\n");
        if (JDomContentHelper.isNewline((Content)text)) {
            return "New Line: '" + value + "'";
        }
        if (JDomContentHelper.isMultiNewLine((Content)text)) {
            return "Multi New Line: '" + value + "'";
        }
        return text.getCType() + " => " + value;
    }

    static boolean hasNewlines(Content content) {
        if (content instanceof Text) {
            Text text = (Text)content;
            String value = text.getValue();
            return StringUtils.countMatches((String)value, (String)"\n") >= 1 && value.trim().length() == 0;
        }
        return false;
    }

    static boolean isNewline(Content content) {
        if (content instanceof Text) {
            Text text = (Text)content;
            String value = text.getValue();
            return StringUtils.countMatches((String)value, (String)"\n") == 1 && value.trim().length() == 0;
        }
        return false;
    }

    static boolean isMultiNewLine(Content content) {
        if (content instanceof Text) {
            Text text = (Text)content;
            String value = text.getValue();
            return StringUtils.countMatches((String)value, (String)"\n") > 1 && value.trim().length() == 0;
        }
        return false;
    }

    static boolean isComment(Content content) {
        return content instanceof Comment;
    }

    static Content getSuccessorOfContentWithIndex(int index, Element parent) {
        return JDomContentHelper.isIndexValid(index + 1, parent) ? parent.getContent(index + 1) : null;
    }

    static Content getPredecessorOfContentWithIndex(int index, Element parent) {
        return JDomContentHelper.isIndexValid(index - 1, parent) ? parent.getContent(index - 1) : null;
    }

    static Content getContentWithIndex(int index, Element parent) {
        return JDomContentHelper.isIndexValid(index, parent) ? parent.getContent(index) : null;
    }

    static boolean isIndexValid(int index, Element element) {
        int numberOfContents = element.getContent().size();
        if (index < 0 || numberOfContents == 0 || index >= numberOfContents) {
            LOG.trace("Parent: {} has no content with index {}", (Object)JDomContentHelper.contentAsString((Content)element), (Object)index);
            return false;
        }
        return true;
    }

    static int countNewlinesPredecessors(Content content) {
        int newLineCount = 0;
        Element parent = content.getParentElement();
        int descendantIndex = parent.indexOf(content);
        Content predecessor = JDomContentHelper.getPredecessorOfContentWithIndex(descendantIndex, parent);
        while (JDomContentHelper.hasNewlines(predecessor)) {
            newLineCount += StringUtils.countMatches((String)predecessor.getValue(), (String)"\n");
            predecessor = JDomContentHelper.getPredecessorOfContentWithIndex(--descendantIndex, parent);
        }
        return newLineCount;
    }
}

