/*
 * Decompiled with CFR 0.152.
 */
package org.xeustechnologies.jtar;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.xeustechnologies.jtar.TarEntry;

public class TarOutputStream
extends FilterOutputStream {
    private long bytesWritten = 0L;
    private long currentFileSize = 0L;
    private TarEntry currentEntry;

    public TarOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void close() throws IOException {
        this.closeCurrentEntry();
        this.write(new byte[1024]);
        super.close();
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        ++this.bytesWritten;
        if (this.currentEntry != null) {
            ++this.currentFileSize;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.currentEntry != null && !this.currentEntry.isDirectory() && this.currentEntry.getSize() < this.currentFileSize + (long)len) {
            throw new IOException("The current entry[" + this.currentEntry.getName() + "] size[" + this.currentEntry.getSize() + "] is smaller than the bytes[" + (this.currentFileSize + (long)len) + "] being written.");
        }
        this.out.write(b, off, len);
        this.bytesWritten += (long)len;
        if (this.currentEntry != null) {
            this.currentFileSize += (long)len;
        }
    }

    public void putNextEntry(TarEntry entry) throws IOException {
        this.closeCurrentEntry();
        byte[] header = new byte[512];
        entry.writeEntryHeader(header);
        this.write(header);
        this.currentEntry = entry;
    }

    protected void closeCurrentEntry() throws IOException {
        if (this.currentEntry != null) {
            if (this.currentEntry.getSize() > this.currentFileSize) {
                throw new IOException("The current entry[" + this.currentEntry.getName() + "] of size[" + this.currentEntry.getSize() + "] has not been fully written.");
            }
            this.currentEntry = null;
            this.currentFileSize = 0L;
            this.pad();
        }
    }

    protected void pad() throws IOException {
        int extra;
        if (this.bytesWritten > 0L && (extra = (int)(this.bytesWritten % 512L)) > 0) {
            this.write(new byte[512 - extra]);
        }
    }
}

