/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack;

import com.codepoetics.protonpack.Indexed;
import com.codepoetics.protonpack.SkipUntilSpliterator;
import com.codepoetics.protonpack.TakeWhileSpliterator;
import com.codepoetics.protonpack.UnfoldSpliterator;
import com.codepoetics.protonpack.ZippingSpliterator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class StreamUtils {
    private StreamUtils() {
    }

    public static LongStream indices() {
        return LongStream.iterate(0L, l -> l + 1L);
    }

    public static <T> Stream<Indexed<T>> zipWithIndex(Stream<T> source) {
        return StreamUtils.zip(StreamUtils.indices().mapToObj(Long::valueOf), source, Indexed::index);
    }

    public static <L, R, O> Stream<O> zip(Stream<L> lefts, Stream<R> rights, BiFunction<L, R, O> combiner) {
        return StreamSupport.stream(ZippingSpliterator.zipping(lefts.spliterator(), rights.spliterator(), combiner), false);
    }

    private static boolean isSized(int characteristics) {
        return (characteristics & 0x40) != 0;
    }

    public static <T> Stream<T> takeWhile(Stream<T> source, Predicate<T> condition) {
        return StreamSupport.stream(TakeWhileSpliterator.over(source.spliterator(), condition), false);
    }

    public static <T> Stream<T> takeUntil(Stream<T> source, Predicate<T> condition) {
        return StreamUtils.takeWhile(source, condition.negate());
    }

    public static <T> Stream<T> skipWhile(Stream<T> source, Predicate<T> condition) {
        return StreamSupport.stream(SkipUntilSpliterator.over(source.spliterator(), condition.negate()), false);
    }

    public static <T> Stream<T> skipUntil(Stream<T> source, Predicate<T> condition) {
        return StreamSupport.stream(SkipUntilSpliterator.over(source.spliterator(), condition), false);
    }

    public static <T> Stream<T> unfold(T seed, Function<T, Optional<T>> generator) {
        return StreamSupport.stream(UnfoldSpliterator.over(seed, generator), false);
    }
}

