/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack;

import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;

class TakeWhileSpliterator<T>
implements Spliterator<T> {
    private final Spliterator<T> source;
    private final Predicate<T> condition;
    private boolean conditionHolds = true;

    static <T> TakeWhileSpliterator<T> over(Spliterator<T> source, Predicate<T> condition) {
        return new TakeWhileSpliterator<T>(source, condition);
    }

    private TakeWhileSpliterator(Spliterator<T> source, Predicate<T> condition) {
        this.source = source;
        this.condition = condition;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        return this.conditionHolds && this.source.tryAdvance(e -> {
            this.conditionHolds = this.condition.test(e);
            if (this.conditionHolds) {
                action.accept(e);
            }
        });
    }

    @Override
    public Spliterator<T> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return this.conditionHolds ? this.source.estimateSize() : 0L;
    }

    @Override
    public int characteristics() {
        return this.source.characteristics() & 0xFFFFFFBF;
    }
}

