/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack.collectors;

import com.codepoetics.protonpack.collectors.NonUniqueValueException;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class CollectorUtils {
    private CollectorUtils() {
    }

    public static <T, Y extends Comparable<Y>> Collector<T, ?, Optional<T>> maxBy(Function<T, Y> projection) {
        return CollectorUtils.maxBy(projection, Comparable::compareTo);
    }

    public static <T, Y> Collector<T, ?, Optional<T>> maxBy(Function<T, Y> projection, Comparator<Y> comparator) {
        return Collectors.maxBy((a, b) -> {
            Object element1 = projection.apply(a);
            Object element2 = projection.apply(b);
            return comparator.compare(element1, element2);
        });
    }

    public static <T, Y extends Comparable<Y>> Collector<T, ?, Optional<T>> minBy(Function<T, Y> projection) {
        return CollectorUtils.minBy(projection, Comparable::compareTo);
    }

    public static <T, Y> Collector<T, ?, Optional<T>> minBy(Function<T, Y> projection, Comparator<Y> comparator) {
        return Collectors.minBy((a, b) -> {
            Object element1 = projection.apply(a);
            Object element2 = projection.apply(b);
            return comparator.compare(element1, element2);
        });
    }

    public static <T> Collector<T, AtomicReference<T>, Optional<T>> unique() {
        return Collector.of(AtomicReference::new, CollectorUtils::uniqueAccumulate, CollectorUtils::uniqueCombine, ref -> Optional.ofNullable(ref.get()), new Collector.Characteristics[0]);
    }

    private static <T> void uniqueAccumulate(AtomicReference<T> a, T t) {
        if (t == null) {
            return;
        }
        if (!a.compareAndSet(null, t)) {
            throw new NonUniqueValueException(a.get(), t);
        }
    }

    private static <T> AtomicReference<T> uniqueCombine(AtomicReference<T> a1, AtomicReference<T> a2) {
        CollectorUtils.uniqueAccumulate(a1, a2.get());
        return a1;
    }

    public static <T> BinaryOperator<T> noCombiner() {
        return (t1, t2) -> {
            throw new UnsupportedOperationException("No combiner supplied for merging parallel results");
        };
    }
}

