/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack.collectors;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class CompletableFutures {
    private CompletableFutures() {
    }

    public static <T> Collector<CompletableFuture<T>, ?, CompletableFuture<List<T>>> toFutureList() {
        return Collectors.collectingAndThen(Collectors.toList(), futures -> {
            AtomicLong resultsRemaining = new AtomicLong(futures.size());
            CompletableFuture result = new CompletableFuture();
            BiFunction<Object, Throwable, Void> handler = (success, failure) -> {
                if (failure == null) {
                    if (resultsRemaining.decrementAndGet() == 0L) {
                        result.complete(futures.stream().map(CompletableFutures::safeGet).collect(Collectors.toList()));
                    }
                } else {
                    result.completeExceptionally((Throwable)failure);
                }
                return null;
            };
            futures.stream().forEach(future -> future.handle(handler));
            return result;
        });
    }

    private static <T> T safeGet(CompletableFuture<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("safeGet called on failed future: " + e);
        }
    }
}

