/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack.stateful;

import com.codepoetics.protonpack.stateful.StateMachine;
import com.codepoetics.protonpack.stateful.Transition;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;

final class StatefulSpliterator<S, I, O>
implements Spliterator<Stream<O>> {
    private final Spliterator<I> inputSpliterator;
    private S state;
    private boolean isFinished = false;
    private final StateMachine<S, I, O> stateMachine;

    static <S, I, O> StatefulSpliterator<S, I, O> over(Stream<I> inputStream, StateMachine<S, I, O> stateMachine) {
        return new StatefulSpliterator(inputStream.spliterator(), stateMachine.getInitialState(), stateMachine);
    }

    private StatefulSpliterator(Spliterator<I> inputSpliterator, S initialState, StateMachine<S, I, O> stateMachine) {
        this.inputSpliterator = inputSpliterator;
        this.state = initialState;
        this.stateMachine = stateMachine;
    }

    public S getState() {
        return this.state;
    }

    @Override
    public boolean tryAdvance(Consumer<? super Stream<O>> action) {
        return !this.isFinished && !this.stateMachine.isTerminal(this.state) && (this.inputSpliterator.tryAdvance((? super T input) -> this.acceptInput(input, action)) || this.finish(action));
    }

    private void acceptInput(I input, Consumer<? super Stream<O>> action) {
        Transition<S, O> transition = this.stateMachine.apply(this.state, input);
        action.accept(transition.getOutputs());
        this.state = transition.getNewState();
    }

    private boolean finish(Consumer<? super Stream<O>> action) {
        action.accept(this.stateMachine.finish(this.state));
        this.isFinished = true;
        return true;
    }

    @Override
    public Spliterator<Stream<O>> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return this.inputSpliterator.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.inputSpliterator.characteristics();
    }
}

