/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack;

import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;

public class PeekableSpliterator<T>
implements Spliterator<T> {
    private final Spliterator<T> source;
    private Optional<T> buffer = Optional.empty();

    public static <T> PeekableSpliterator<T> peeking(Spliterator<T> spliterator) {
        return new PeekableSpliterator<T>(spliterator);
    }

    private PeekableSpliterator(Spliterator<T> source) {
        this.source = source;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        boolean hadNext = this.tryPeek(action);
        this.buffer = Optional.empty();
        return hadNext;
    }

    public boolean tryPeek(Consumer<? super T> action) {
        if (this.buffer.isPresent()) {
            this.buffer.ifPresent(action);
            return true;
        }
        return this.source.tryAdvance(e -> {
            this.buffer = Optional.of(e);
            action.accept(e);
        });
    }

    @Override
    public Spliterator<T> trySplit() {
        return this.source.trySplit();
    }

    @Override
    public long estimateSize() {
        return this.source.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.source.characteristics();
    }
}

