package com.codepoetics.protonpack;

import java.util.Comparator;
import java.util.stream.Stream;

public final class Selectors {
    Selectors() {

    }

    public static <T> Selector<T> roundRobin() {
        return new Selector<T>() {
            private int startIndex = 0;
            @Override
            public Integer apply(T[] options) {
                int result = startIndex;
                while (options[result] == null) {
                    result = (result + 1) % options.length;
                }

                startIndex = (result + 1) % options.length;
                return result;
            }
        };
    }

    public static <T extends Comparable<T>> Selector<T> takeMin() {
        return takeMin(Comparator.naturalOrder());
    }

    public static <T> Selector<T> takeMin(Comparator<? super T> comparator) {
        return new Selector<T>() {

            private int startIndex = 0;

            @Override
            public Integer apply(T[] options) {
                T smallest = Stream.of(options).filter(t -> t != null).min(comparator).get();

                int result = startIndex;
                while (options[result] == null || comparator.compare(smallest, options[result]) != 0) {
                    result = (result + 1) % options.length;
                }

                startIndex = (result + 1) % options.length;
                return result;
            }
        };
    }

    public static <T extends Comparable<T>> Selector<T> takeMax() {
        return takeMax(Comparator.naturalOrder());
    }

    public static <T> Selector<T> takeMax(Comparator<? super T> comparator) {
        return takeMin(comparator.reversed());
    }
}
