/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Streamable<T> {
    public static <T> Streamable<T> empty() {
        return Stream::empty;
    }

    public static <T> Streamable<T> of(Streamable<T> streamable) {
        return streamable;
    }

    public static <T> Streamable<T> of(T ... items) {
        return () -> Stream.of(items);
    }

    public static <T> Streamable<T> of(Collection<T> collection) {
        return collection::stream;
    }

    public static <T> Streamable<T> of(Iterable<T> iterable) {
        return () -> StreamSupport.stream(iterable.spliterator(), false);
    }

    @SafeVarargs
    public static <T> Streamable<T> of(Streamable<T> ... streamables) {
        return Stream.of(streamables).reduce(Streamable::concat).orElseGet(Streamable::empty);
    }

    public Stream<T> stream();

    default public Streamable<T> concat(Streamable<T> streamable) {
        return () -> Stream.concat(this.stream(), streamable.stream());
    }

    default public <T2> Streamable<T2> transform(Function<Stream<T>, Stream<T2>> transformer) {
        return () -> (Stream)transformer.apply(this.stream());
    }

    default public <T2> Streamable<T2> map(Function<? super T, ? extends T2> f) {
        return this.transform(s -> s.map(f));
    }

    default public <T2> Streamable<T2> flatMap(Function<? super T, Stream<? extends T2>> f) {
        return this.transform(s -> s.flatMap(f));
    }

    default public Streamable<T> filter(Predicate<? super T> predicate) {
        return this.transform(s -> s.filter(predicate));
    }

    default public Streamable<T> sorted(Comparator<? super T> comparator) {
        return () -> this.stream().sorted(comparator);
    }

    default public Streamable<T> skip(long n) {
        return () -> this.stream().skip(n);
    }

    default public void forEach(Consumer<T> action) {
        this.stream().forEach(action);
    }

    default public void forEachOrdered(Consumer<T> action) {
        this.stream().forEachOrdered(action);
    }

    default public <O> O collect(Collector<T, ?, O> collector) {
        return this.stream().collect(collector);
    }

    default public List<T> toList() {
        return this.collect(Collectors.toList());
    }

    default public Set<T> toSet() {
        return this.collect(Collectors.toSet());
    }

    default public <K> Map<K, T> toMap(Function<? super T, ? extends K> indexFunction) {
        return this.collect(Collectors.toMap(indexFunction, v -> v));
    }

    default public <K, V> Map<K, V> toMap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        return this.collect(Collectors.toMap(keyFunction, valueFunction));
    }

    default public T[] toArray(IntFunction<T[]> arrayConstructor) {
        return this.stream().toArray(arrayConstructor);
    }
}

