/*
 * Decompiled with CFR 0.152.
 */
package com.codepulsar.nils.adapter.gson;

import com.codepulsar.nils.adapter.gson.GsonAdapterConfig;
import com.codepulsar.nils.adapter.gson.utils.GsonErrorTypes;
import com.codepulsar.nils.api.error.NilsException;
import com.codepulsar.nils.core.adapter.AdapterContext;
import com.codepulsar.nils.core.adapter.BaseLocalizedResourceAdapter;
import com.codepulsar.nils.core.adapter.util.LocalizedResourceResolver;
import com.codepulsar.nils.core.adapter.util.MapTranslationRetriever;
import com.codepulsar.nils.core.error.ErrorTypes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonAdapter
extends BaseLocalizedResourceAdapter<GsonAdapter, GsonAdapterConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(GsonAdapter.class);

    public GsonAdapter(AdapterContext<GsonAdapter> context) {
        super(context);
    }

    protected void initTranslations(LocalizedResourceResolver resolver) {
        Gson gson = new GsonBuilder().create();
        try (InputStreamReader fileReader = new InputStreamReader(resolver.resolve(), StandardCharsets.UTF_8);
             JsonReader jsonReader = new JsonReader((Reader)fileReader);){
            Map translations = (Map)gson.fromJson(jsonReader, Map.class);
            this.translation = new MapTranslationRetriever(translations);
            LOG.debug("Translation for locale {} read.", (Object)this.locale);
        }
        catch (JsonIOException | JsonSyntaxException | IOException e) {
            throw GsonErrorTypes.CORRUPT_FILE_ERROR.asException().message("Error reading JSON file '%s'.").args(new Object[]{resolver.getUsedResourceName()}).cause(e).go();
        }
        finally {
            resolver.close();
        }
        this.resourceName = resolver.getUsedResourceName();
    }

    protected InputStream resolveInputStream(String resource) {
        try {
            Module owner = ((GsonAdapterConfig)this.adapterConfig).getOwnerModule();
            return owner.getResourceAsStream(resource);
        }
        catch (IOException e) {
            LOG.error("Error getting resource {}.", (Object)e, (Object)resource);
            throw new NilsException(ErrorTypes.IO_ERROR, "Error getting resource %s.", (Throwable)e, new Object[]{resource});
        }
    }
}

