/*
 * Decompiled with CFR 0.152.
 */
package com.codepulsar.nils.adapter.jdbc;

import com.codepulsar.nils.adapter.jdbc.JdbcAdapterConfig;
import com.codepulsar.nils.adapter.jdbc.utils.JdbcErrorTypes;
import com.codepulsar.nils.api.adapter.Adapter;
import com.codepulsar.nils.api.error.ErrorType;
import com.codepulsar.nils.api.error.NilsException;
import com.codepulsar.nils.core.adapter.AdapterContext;
import com.codepulsar.nils.core.adapter.util.FallbackAdapterHandler;
import com.codepulsar.nils.core.error.ErrorTypes;
import com.codepulsar.nils.core.util.ParameterCheck;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcAdapter
implements Adapter {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcAdapter.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final AdapterContext<JdbcAdapter> adapterContext;
    private final Locale locale;
    private final JdbcAdapterConfig adapterConfig;
    private final Map<String, Optional<String>> cache = new HashMap<String, Optional<String>>();
    private boolean fallbackPossible = true;
    private String selectStatement;
    private final FallbackAdapterHandler<JdbcAdapter> fallbackAdapterHandler;
    private LocalDateTime nextReset;

    protected JdbcAdapter(AdapterContext<JdbcAdapter> context) {
        this.adapterContext = (AdapterContext)ParameterCheck.notNull(context, (String)"context");
        ParameterCheck.notNull((Object)context.getConfig(), (String)"context.config");
        ParameterCheck.notNull((Object)context.getLocale(), (String)"context.locale");
        if (!(context.getConfig() instanceof JdbcAdapterConfig)) {
            throw ErrorTypes.ADAPTER_ERROR.asException().message("The provided AdapterConfig (%s) does not implement %s.").args(new Object[]{context.getConfig(), JdbcAdapter.class.getName()}).go();
        }
        this.adapterConfig = (JdbcAdapterConfig)context.getConfig();
        this.locale = context.getLocale();
        this.fallbackAdapterHandler = new FallbackAdapterHandler(this.adapterContext, this.adapterConfig.getRootLocale());
        this.checkConnectionConfig();
        this.initSelectStatement();
        this.initFallbackAvailable();
        this.nextReset = LocalDateTime.now().plusSeconds(this.adapterConfig.getCacheTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> getTranslation(String key) {
        this.lock.lock();
        try {
            ParameterCheck.notNullEmptyOrBlank((String)key, (String)"key");
            this.resetCache();
            Optional<String> value = this.cache.computeIfAbsent(key, this::resolveTranslation);
            if (value.isPresent()) {
                Optional<String> optional = value;
                return optional;
            }
            if (this.fallbackPossible) {
                value = ((JdbcAdapter)this.fallbackAdapterHandler.getFallbackAdapter()).getTranslation(key);
            }
            Optional<String> optional = value;
            return optional;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void resetCache() {
        if (this.adapterConfig.getCacheTimeout() < 0L) {
            return;
        }
        if (LocalDateTime.now().isAfter(this.nextReset)) {
            this.cache.clear();
            this.nextReset = LocalDateTime.now().plusSeconds(this.adapterConfig.getCacheTimeout());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<String> resolveTranslation(String key) {
        this.initByDriverName();
        try (Connection con = DriverManager.getConnection(this.adapterConfig.getUrl(), this.adapterConfig.getUsername(), this.adapterConfig.getPassword());
             PreparedStatement statement = con.prepareStatement(this.selectStatement);){
            statement.setString(1, key);
            statement.setString(2, this.locale.toString());
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return Optional.empty();
                Optional<String> optional = Optional.ofNullable(resultSet.getString(this.adapterConfig.getValueField()));
                return optional;
            }
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw JdbcErrorTypes.SQL_EXCEPTION.asException().cause((Throwable)e).args(new Object[]{e.getMessage()}).go();
        }
    }

    private void initByDriverName() {
        String driverClass = this.adapterConfig.getDriverClass();
        if (driverClass != null && !driverClass.isBlank()) {
            try {
                Class.forName(driverClass);
            }
            catch (ClassNotFoundException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw JdbcErrorTypes.MISSING_JDBC_DRIVER.asException().cause((Throwable)e).go();
            }
        }
    }

    private void checkConnectionConfig() {
        try {
            ParameterCheck.notNullEmptyOrBlank((String)this.adapterConfig.getUrl(), (String)"url", (Function)ParameterCheck.nilsException((ErrorType)ErrorTypes.CONFIG_ERROR));
            ParameterCheck.notNullEmptyOrBlank((String)this.adapterConfig.getUsername(), (String)"username", (Function)ParameterCheck.nilsException((ErrorType)ErrorTypes.CONFIG_ERROR));
        }
        catch (NilsException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw JdbcErrorTypes.INCOMPLETE_CONNECTION_DATA.asException().cause((Throwable)e).go();
        }
    }

    private void initSelectStatement() {
        String table = this.adapterConfig.getSchema() != null ? this.adapterConfig.getSchema() + "." + this.adapterConfig.getTableName() : this.adapterConfig.getTableName();
        this.selectStatement = String.format("SELECT %1$s FROM %2$s WHERE %3$s = ? AND %4$s = ?", this.adapterConfig.getValueField(), table, this.adapterConfig.getKeyField(), this.adapterConfig.getLocaleField());
    }

    private void initFallbackAvailable() {
        this.fallbackPossible = this.adapterConfig.isFallbackActive() && !this.adapterConfig.getRootLocale().equals(this.locale);
    }
}

