/*
 * Decompiled with CFR 0.152.
 */
package com.codepulsar.nils.adapter.jdbc;

import com.codepulsar.nils.adapter.jdbc.JdbcAdapterFactory;
import com.codepulsar.nils.api.adapter.AdapterFactory;
import com.codepulsar.nils.api.error.ErrorType;
import com.codepulsar.nils.core.adapter.config.BaseNilsConfig;
import com.codepulsar.nils.core.error.ErrorTypes;
import com.codepulsar.nils.core.util.ParameterCheck;
import java.util.Locale;
import java.util.function.Function;

public class JdbcAdapterConfig
extends BaseNilsConfig<JdbcAdapterConfig> {
    private String url;
    private String username;
    private String password = "";
    private String driverClass;
    private boolean fallbackActive = true;
    private Locale rootLocale = new Locale("");
    private String schema = null;
    private String tableName = "NILS_TRANSLATION";
    private String localeField = "NLS_LOCALE";
    private String keyField = "NLS_KEY";
    private String valueField = "NLS_VALUE";
    private long cacheTimeout = -1L;

    public String getUrl() {
        return this.url;
    }

    protected JdbcAdapterConfig url(String url) {
        this.url = ParameterCheck.notNullEmptyOrBlank((String)url, (String)"url", (Function)ParameterCheck.nilsException((ErrorType)ErrorTypes.CONFIG_ERROR)).trim();
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    protected JdbcAdapterConfig username(String username) {
        this.username = ParameterCheck.notNullEmptyOrBlank((String)username, (String)"username", (Function)ParameterCheck.nilsException((ErrorType)ErrorTypes.CONFIG_ERROR)).trim();
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    protected JdbcAdapterConfig password(String password) {
        this.password = ((String)ParameterCheck.notNull((Object)password, (String)"password", (Function)ParameterCheck.nilsException((ErrorType)ErrorTypes.CONFIG_ERROR))).trim();
        return this;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public JdbcAdapterConfig driverClass(String driverClass) {
        this.driverClass = ParameterCheck.notNullEmptyOrBlank((String)driverClass, (String)"driverClass", (Function)ParameterCheck.nilsException((ErrorType)ErrorTypes.CONFIG_ERROR)).trim();
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    public JdbcAdapterConfig schema(String schema) {
        this.schema = ParameterCheck.notNullEmptyOrBlank((String)schema, (String)"schema", (Function)ParameterCheck.nilsException((ErrorType)ErrorTypes.CONFIG_ERROR)).trim();
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public JdbcAdapterConfig tableName(String tableName) {
        this.tableName = ParameterCheck.notNullEmptyOrBlank((String)tableName, (String)"tableName", (Function)ParameterCheck.nilsException((ErrorType)ErrorTypes.CONFIG_ERROR)).trim();
        return this;
    }

    public String getLocaleField() {
        return this.localeField;
    }

    public JdbcAdapterConfig localeField(String localeField) {
        this.localeField = ParameterCheck.notNullEmptyOrBlank((String)localeField, (String)"localeField", (Function)ParameterCheck.nilsException((ErrorType)ErrorTypes.CONFIG_ERROR)).trim();
        return this;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public JdbcAdapterConfig keyField(String keyField) {
        this.keyField = ParameterCheck.notNullEmptyOrBlank((String)keyField, (String)"keyField", (Function)ParameterCheck.nilsException((ErrorType)ErrorTypes.CONFIG_ERROR)).trim();
        return this;
    }

    public String getValueField() {
        return this.valueField;
    }

    public JdbcAdapterConfig valueField(String valueField) {
        this.valueField = ParameterCheck.notNullEmptyOrBlank((String)valueField, (String)"valueField", (Function)ParameterCheck.nilsException((ErrorType)ErrorTypes.CONFIG_ERROR)).trim();
        return this;
    }

    public long getCacheTimeout() {
        return this.cacheTimeout;
    }

    public JdbcAdapterConfig cacheTimeout(long cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
        return this;
    }

    public boolean isFallbackActive() {
        return this.fallbackActive;
    }

    public JdbcAdapterConfig fallbackActive(boolean fallback) {
        this.fallbackActive = fallback;
        return this;
    }

    public Locale getRootLocale() {
        return this.rootLocale;
    }

    public JdbcAdapterConfig rootLocale(Locale rootLocale) {
        this.rootLocale = (Locale)ParameterCheck.notNull((Object)rootLocale, (String)"rootLocale", (Function)ParameterCheck.nilsException((ErrorType)ErrorTypes.CONFIG_ERROR));
        return this;
    }

    public Class<? extends AdapterFactory<?>> getFactoryClass() {
        return JdbcAdapterFactory.class;
    }

    public static JdbcAdapterConfig init(String url, String username, String password) {
        JdbcAdapterConfig config = new JdbcAdapterConfig();
        config.url(url).username(username);
        if (password != null) {
            config.password(password);
        }
        return config;
    }
}

