/*
 * Decompiled with CFR 0.152.
 */
package com.codepulsar.nils.adapter.snakeyaml;

import com.codepulsar.nils.adapter.snakeyaml.SnakeYamlAdapterConfig;
import com.codepulsar.nils.adapter.snakeyaml.utils.SnakeYamlErrorTypes;
import com.codepulsar.nils.api.error.NilsException;
import com.codepulsar.nils.core.adapter.AdapterContext;
import com.codepulsar.nils.core.adapter.BaseLocalizedResourceAdapter;
import com.codepulsar.nils.core.adapter.util.LocalizedResourceResolver;
import com.codepulsar.nils.core.adapter.util.MapTranslationRetriever;
import com.codepulsar.nils.core.error.ErrorTypes;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;

public class SnakeYamlAdapter
extends BaseLocalizedResourceAdapter<SnakeYamlAdapter, SnakeYamlAdapterConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(SnakeYamlAdapter.class);

    public SnakeYamlAdapter(AdapterContext<SnakeYamlAdapter> context) {
        super(context);
    }

    protected void initTranslations(LocalizedResourceResolver resolver) {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setAllowDuplicateKeys(false);
        Yaml yaml = new Yaml(loaderOptions);
        try (InputStreamReader fileReader = new InputStreamReader(resolver.resolve(), StandardCharsets.UTF_8);){
            Map translations = (Map)yaml.load((Reader)fileReader);
            this.translation = new MapTranslationRetriever(translations);
            LOG.debug("Translation for locale {} read.", (Object)this.locale);
        }
        catch (NilsException e) {
            throw e;
        }
        catch (Exception e) {
            throw SnakeYamlErrorTypes.CORRUPT_FILE_ERROR.asException().message("Error reading YAML file '%s'.").args(new Object[]{resolver.getUsedResourceName()}).cause((Throwable)e).go();
        }
        finally {
            resolver.close();
        }
        this.resourceName = resolver.getUsedResourceName();
    }

    protected InputStream resolveInputStream(String resource) {
        try {
            Module owner = ((SnakeYamlAdapterConfig)this.adapterConfig).getOwnerModule();
            return owner.getResourceAsStream(resource);
        }
        catch (IOException e) {
            LOG.error("Error getting resource {}.", (Object)e, (Object)resource);
            throw new NilsException(ErrorTypes.IO_ERROR, "Error getting resource %s.", (Throwable)e, new Object[]{resource});
        }
    }
}

